/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.vocabularies;

import amf.ProfileNames$;
import amf.client.render.RenderOptions;
import amf.core.Root;
import amf.core.metamodel.Obj;
import amf.core.model.document.BaseUnit;
import amf.core.model.domain.AnnotationGraphLoader;
import amf.core.parser.ParserContext;
import amf.core.parser.ReferenceHandler;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFPlugin;
import amf.core.plugins.AMFValidationPlugin;
import amf.core.registries.AMFDomainEntityResolver;
import amf.core.remote.Platform;
import amf.core.resolution.pipelines.ResolutionPipeline$;
import amf.core.services.RuntimeValidator$;
import amf.core.validation.AMFValidationReport;
import amf.core.validation.AMFValidationResult;
import amf.core.validation.EffectiveValidations;
import amf.core.validation.SeverityLevels$;
import amf.core.validation.ValidationResultProcessor;
import amf.core.validation.core.ValidationProfile;
import amf.core.validation.core.ValidationResult;
import amf.plugins.document.vocabularies.DialectHeader$;
import amf.plugins.document.vocabularies.DialectsRegistry;
import amf.plugins.document.vocabularies.RamlHeaderExtractor;
import amf.plugins.document.vocabularies.annotations.AliasesLocation$;
import amf.plugins.document.vocabularies.annotations.CustomId$;
import amf.plugins.document.vocabularies.emitters.dialects.RamlDialectEmitter;
import amf.plugins.document.vocabularies.emitters.dialects.RamlDialectLibraryEmitter;
import amf.plugins.document.vocabularies.emitters.instances.RamlDialectInstancesEmitter;
import amf.plugins.document.vocabularies.emitters.vocabularies.RamlVocabularyEmitter;
import amf.plugins.document.vocabularies.metamodel.document.DialectFragmentModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstanceFragmentModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstanceLibraryModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectInstanceModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectLibraryModel$;
import amf.plugins.document.vocabularies.metamodel.document.DialectModel$;
import amf.plugins.document.vocabularies.metamodel.document.VocabularyModel$;
import amf.plugins.document.vocabularies.metamodel.domain.ClassTermModel$;
import amf.plugins.document.vocabularies.metamodel.domain.DatatypePropertyTermModel$;
import amf.plugins.document.vocabularies.metamodel.domain.DocumentMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.DocumentsModelModel$;
import amf.plugins.document.vocabularies.metamodel.domain.ExternalModel$;
import amf.plugins.document.vocabularies.metamodel.domain.NodeMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.ObjectPropertyTermModel$;
import amf.plugins.document.vocabularies.metamodel.domain.PropertyMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.PublicNodeMappingModel$;
import amf.plugins.document.vocabularies.metamodel.domain.VocabularyReferenceModel$;
import amf.plugins.document.vocabularies.model.document.Dialect;
import amf.plugins.document.vocabularies.model.document.DialectInstance;
import amf.plugins.document.vocabularies.model.document.DialectLibrary;
import amf.plugins.document.vocabularies.model.document.Vocabulary;
import amf.plugins.document.vocabularies.parser.ExtensionHeader$;
import amf.plugins.document.vocabularies.parser.common.RAMLExtensionsReferenceHandler;
import amf.plugins.document.vocabularies.parser.dialects.DialectContext;
import amf.plugins.document.vocabularies.parser.dialects.DialectContext$;
import amf.plugins.document.vocabularies.parser.dialects.RamlDialectsParser;
import amf.plugins.document.vocabularies.parser.instances.DialectInstanceContext;
import amf.plugins.document.vocabularies.parser.instances.DialectInstanceContext$;
import amf.plugins.document.vocabularies.parser.instances.RamlDialectInstanceParser;
import amf.plugins.document.vocabularies.parser.vocabularies.RamlVocabulariesParser;
import amf.plugins.document.vocabularies.parser.vocabularies.VocabularyContext;
import amf.plugins.document.vocabularies.parser.vocabularies.VocabularyContext$;
import amf.plugins.document.vocabularies.resolution.pipelines.DialectInstanceResolutionPipeline;
import amf.plugins.document.vocabularies.resolution.pipelines.DialectResolutionPipeline;
import amf.plugins.document.vocabularies.validation.AMFDialectValidations;
import java.io.Serializable;
import org.yaml.model.YComment;
import org.yaml.model.YDocument;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;

public final class RAMLVocabulariesPlugin$
extends AMFDocumentPlugin
implements RamlHeaderExtractor,
AMFValidationPlugin,
ValidationResultProcessor {
    public static RAMLVocabulariesPlugin$ MODULE$;
    private final DialectsRegistry registry;
    private final String ID;
    private final Seq<String> vendors;
    private Map<String, ValidationProfile> validationsProfilesMap;

    static {
        new RAMLVocabulariesPlugin$();
    }

    public AMFValidationResult processAggregatedResult(AMFValidationResult result, String messageStyle, EffectiveValidations validations) {
        return ValidationResultProcessor.processAggregatedResult$((ValidationResultProcessor)this, (AMFValidationResult)result, (String)messageStyle, (EffectiveValidations)validations);
    }

    public Option<AMFValidationResult> buildValidationResult(BaseUnit model, ValidationResult result, String messageStyle, EffectiveValidations validations) {
        return ValidationResultProcessor.buildValidationResult$((ValidationResultProcessor)this, (BaseUnit)model, (ValidationResult)result, (String)messageStyle, (EffectiveValidations)validations);
    }

    public String findLevel(String id, EffectiveValidations validations) {
        return ValidationResultProcessor.findLevel$((ValidationResultProcessor)this, (String)id, (EffectiveValidations)validations);
    }

    @Override
    public Option<YComment> comment(Root root) {
        return RamlHeaderExtractor.comment$((RamlHeaderExtractor)this, root);
    }

    @Override
    public Option<YComment> comment(YDocument document) {
        return RamlHeaderExtractor.comment$((RamlHeaderExtractor)this, document);
    }

    public DialectsRegistry registry() {
        return this.registry;
    }

    public String ID() {
        return this.ID;
    }

    public Seq<String> vendors() {
        return this.vendors;
    }

    public Future<AMFPlugin> init() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Seq<Obj> modelEntities() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Obj[]{VocabularyModel$.MODULE$, ExternalModel$.MODULE$, VocabularyReferenceModel$.MODULE$, ClassTermModel$.MODULE$, ObjectPropertyTermModel$.MODULE$, DatatypePropertyTermModel$.MODULE$, DialectModel$.MODULE$, NodeMappingModel$.MODULE$, PropertyMappingModel$.MODULE$, DocumentsModelModel$.MODULE$, PublicNodeMappingModel$.MODULE$, DocumentMappingModel$.MODULE$, DialectLibraryModel$.MODULE$, DialectFragmentModel$.MODULE$, DialectInstanceModel$.MODULE$, DialectInstanceLibraryModel$.MODULE$, DialectInstanceFragmentModel$.MODULE$}));
    }

    public Map<String, AnnotationGraphLoader> serializableAnnotations() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aliases-location"), (Object)AliasesLocation$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom-id"), (Object)CustomId$.MODULE$)}));
    }

    public BaseUnit resolve(BaseUnit unit, String pipelineId) {
        BaseUnit baseUnit;
        BaseUnit baseUnit2 = unit;
        if (baseUnit2 instanceof Dialect) {
            Dialect dialect = (Dialect)baseUnit2;
            baseUnit = new DialectResolutionPipeline().resolve(dialect);
        } else if (baseUnit2 instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit2;
            baseUnit = new DialectInstanceResolutionPipeline().resolve(dialectInstance);
        } else {
            baseUnit = unit;
        }
        return baseUnit;
    }

    public String resolve$default$2() {
        return ResolutionPipeline$.MODULE$.DEFAULT_PIPELINE();
    }

    public Seq<String> documentSyntaxes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"application/raml", "application/raml+json", "application/raml+yaml", "text/yaml", "text/x-yaml", "application/yaml", "application/x-yaml"}));
    }

    public Option<BaseUnit> parse(Root document, ParserContext parentContext, Platform platform) {
        None$ none$;
        Option<YComment> option = this.comment(document);
        if (option instanceof Some) {
            Object object;
            Some some = (Some)option;
            YComment comment = (YComment)some.value();
            String string = comment.metaText();
            String string2 = ExtensionHeader$.MODULE$.VocabularyHeader();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                object = new Some<BaseUnit>((Object)new RamlVocabulariesParser(document, new VocabularyContext(parentContext, VocabularyContext$.MODULE$.$lessinit$greater$default$2())).parseDocument());
            } else {
                String string4 = ExtensionHeader$.MODULE$.DialectLibraryHeader();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    object = new Some((Object)new RamlDialectsParser(document, new DialectContext(parentContext, DialectContext$.MODULE$.$lessinit$greater$default$2())).parseLibrary());
                } else {
                    String string6 = ExtensionHeader$.MODULE$.DialectFragmentHeader();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        object = new Some((Object)new RamlDialectsParser(document, new DialectContext(parentContext, DialectContext$.MODULE$.$lessinit$greater$default$2())).parseFragment());
                    } else {
                        String string8 = ExtensionHeader$.MODULE$.DialectHeader();
                        String string9 = string;
                        object = !(string8 != null ? !string8.equals(string9) : string9 != null) ? this.parseAndRegisterDialect(document, parentContext) : this.parseDialectInstance(string, document, parentContext);
                    }
                }
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<YDocument> unparse(BaseUnit unit, RenderOptions options) {
        Some some;
        BaseUnit baseUnit = unit;
        if (baseUnit instanceof Vocabulary) {
            Vocabulary vocabulary = (Vocabulary)baseUnit;
            some = new Some((Object)new RamlVocabularyEmitter(vocabulary).emitVocabulary());
        } else if (baseUnit instanceof Dialect) {
            Dialect dialect = (Dialect)baseUnit;
            some = new Some((Object)new RamlDialectEmitter(dialect).emitDialect());
        } else if (baseUnit instanceof DialectLibrary) {
            DialectLibrary dialectLibrary = (DialectLibrary)baseUnit;
            some = new Some((Object)new RamlDialectLibraryEmitter(dialectLibrary).emitDialectLibrary());
        } else if (baseUnit instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit;
            some = new Some((Object)new RamlDialectInstancesEmitter(dialectInstance, (Dialect)this.registry().dialectFor(dialectInstance).get()).emitInstance());
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean canParse(Root document) {
        return DialectHeader$.MODULE$.apply(document);
    }

    public boolean canUnparse(BaseUnit unit) {
        boolean bl;
        BaseUnit baseUnit = unit;
        if (baseUnit instanceof Vocabulary) {
            bl = true;
        } else if (baseUnit instanceof Dialect) {
            bl = true;
        } else if (baseUnit instanceof DialectLibrary) {
            bl = true;
        } else if (baseUnit instanceof DialectInstance) {
            DialectInstance dialectInstance = (DialectInstance)baseUnit;
            bl = this.registry().knowsDialectInstance(dialectInstance);
        } else {
            bl = false;
        }
        return bl;
    }

    public ReferenceHandler referenceHandler() {
        return new RAMLExtensionsReferenceHandler();
    }

    public Seq<AMFPlugin> dependencies() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Option<AMFDomainEntityResolver> modelEntitiesResolver() {
        return new Some((Object)this.registry());
    }

    private Some<BaseUnit> parseAndRegisterDialect(Root document, ParserContext parentContext) {
        Some some;
        BaseUnit baseUnit = new RamlDialectsParser(document, new DialectContext(parentContext, DialectContext$.MODULE$.$lessinit$greater$default$2())).parseDocument();
        if (baseUnit instanceof Dialect) {
            Dialect dialect = (Dialect)baseUnit;
            this.registry().register(dialect);
            some = new Some((Object)dialect);
        } else {
            some = new Some((Object)baseUnit);
        }
        return some;
    }

    public Option<BaseUnit> parseDialectInstance(String header, Root document, ParserContext parentContext) {
        String headerKey = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header.split("\\|"))).head()).replace(" ", "");
        return this.registry().withRegisteredDialect(header, (Function1<Dialect, Option<BaseUnit>>)(Function1 & Serializable & scala.Serializable)dialect -> {
            Object object;
            String string = headerKey;
            String string2 = dialect.header();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = new RamlDialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3())).parseDocument();
            } else if (dialect.isFragmentHeader(headerKey)) {
                object = new RamlDialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3())).parseFragment();
            } else if (dialect.isLibraryHeader(headerKey)) {
                object = new RamlDialectInstanceParser(document, new DialectInstanceContext((Dialect)dialect, parentContext, DialectInstanceContext$.MODULE$.$lessinit$greater$default$3())).parseLibrary();
            } else {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown type of dialect header ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})));
            }
            return object;
        });
    }

    public Map<String, ValidationProfile> validationsProfilesMap() {
        return this.validationsProfilesMap;
    }

    public void validationsProfilesMap_$eq(Map<String, ValidationProfile> x$1) {
        this.validationsProfilesMap = x$1;
    }

    public Map<String, Function0<ValidationProfile>> domainValidationProfiles(Platform platform) {
        return (Map)this.registry().allDialects().foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                Dialect dialect = (Dialect)tuple2._2();
                if (!dialect.nameAndVersion().contains("Validation Profile")) {
                    return acc.updated((Object)dialect.nameAndVersion(), (Function0 & Serializable & scala.Serializable)() -> this.computeValidationProfile(dialect));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Map acc = (Map)tuple2._1();
            return acc;
        });
    }

    public ValidationProfile computeValidationProfile(Dialect dialect) {
        ValidationProfile validationProfile;
        String profileName = dialect.nameAndVersion();
        Option option = this.validationsProfilesMap().get((Object)profileName);
        if (option instanceof Some) {
            ValidationProfile profile;
            Some some = (Some)option;
            validationProfile = profile = (ValidationProfile)some.value();
        } else {
            Dialect resolvedDialect = new DialectResolutionPipeline().resolve(dialect);
            ValidationProfile profile = new AMFDialectValidations(resolvedDialect).profile();
            this.validationsProfilesMap_$eq((Map<String, ValidationProfile>)this.validationsProfilesMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profileName), (Object)profile)));
            validationProfile = profile;
        }
        return validationProfile;
    }

    public EffectiveValidations aggregatValidations(EffectiveValidations validations, Seq<ValidationProfile> dependenciesValidations) {
        return (EffectiveValidations)dependenciesValidations.foldLeft((Object)validations, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            EffectiveValidations effective = (EffectiveValidations)tuple2._1();
            ValidationProfile profile = (ValidationProfile)tuple2._2();
            EffectiveValidations effectiveValidations = effective.someEffective(profile);
            return effectiveValidations;
        });
    }

    public Future<AMFValidationReport> validationRequest(BaseUnit baseUnit, String profile, EffectiveValidations validations, Platform platform) {
        BaseUnit baseUnit2 = baseUnit;
        if (!(baseUnit2 instanceof DialectInstance)) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve base unit of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUnit.getClass()})));
        }
        DialectInstance dialectInstance = (DialectInstance)baseUnit2;
        DialectInstance resolvedModel = new DialectInstanceResolutionPipeline().resolve(dialectInstance);
        Future dependenciesValidations = Future$.MODULE$.sequence((TraversableOnce)dialectInstance.graphDependencies().map((Function1 & Serializable & scala.Serializable)instance -> this.registry().registerDialect(instance.value()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)dialects -> (Seq)dialects.map((Function1 & Serializable & scala.Serializable)dialect -> this.computeValidationProfile((Dialect)dialect), Seq$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global());
        Future future = dependenciesValidations.flatMap((Function1 & Serializable & scala.Serializable)validationsFromDeps -> RuntimeValidator$.MODULE$.shaclValidation((BaseUnit)resolvedModel, this.aggregatValidations(validations, (Seq<ValidationProfile>)validationsFromDeps), RuntimeValidator$.MODULE$.shaclValidation$default$3()).map((Function1 & Serializable & scala.Serializable)shaclReport -> {
            List results = (List)shaclReport.results().flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.option2Iterable(this.buildValidationResult(baseUnit, (ValidationResult)r, ProfileNames$.MODULE$.RAML(), validations)), List$.MODULE$.canBuildFrom());
            return new AMFValidationReport(!results.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RAMLVocabulariesPlugin$.$anonfun$validationRequest$7(x$1))), baseUnit.id(), profile, (Seq)results);
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$validationRequest$7(AMFValidationResult x$1) {
        String string = x$1.level();
        String string2 = SeverityLevels$.MODULE$.VIOLATION();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private RAMLVocabulariesPlugin$() {
        MODULE$ = this;
        RamlHeaderExtractor.$init$(this);
        ValidationResultProcessor.$init$((ValidationResultProcessor)this);
        this.registry = new DialectsRegistry();
        this.ID = "RAML Vocabularies";
        this.vendors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RAML Vocabularies"}));
        this.validationsProfilesMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

