/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.xml.util;

import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingUtils {
    public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            thread.setContextClassLoader(classLoader);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentClassLoader != classLoader) {
                thread.setContextClassLoader(currentClassLoader);
            }
        }
    }
}

