package amf.xml.client.platform.plugin

import amf.apicontract.internal.convert.ApiClientConverters._
import amf.core.client.common.validation.ValidationMode
import amf.core.client.platform.model.domain.Shape
import amf.core.client.platform.validation.payload.{AMFShapePayloadValidationPlugin, AMFShapePayloadValidator, ShapeValidationConfiguration, ValidatePayloadRequest}
import amf.core.internal.convert.PayloadValidatorConverter._
import amf.xml.client.scala.plugin.{XmlValidationPlugin => InternalXmlValidationPlugin}

import scala.concurrent.ExecutionContext

class XmlValidationPlugin private(private val _internal: InternalXmlValidationPlugin) extends AMFShapePayloadValidationPlugin {

  def this() = this(new InternalXmlValidationPlugin())

  override val id: String = _internal.id

  override def applies(element: ValidatePayloadRequest): Boolean = _internal.applies(element._internal)

  override def validator(shape: Shape, mediaType: String, config: ShapeValidationConfiguration, validationMode: ValidationMode): AMFShapePayloadValidator = {
    implicit val executionContext: ExecutionContext = config.executionContext
    PayloadValidatorMatcher.asClient(_internal.validator(shape, mediaType, config, validationMode))
  }
}
