package amf.xml.client.scala.plugin

import amf.core.client.common.validation.ValidationMode
import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.validation.payload.{AMFShapePayloadValidationPlugin, AMFShapePayloadValidator, ShapeValidationConfiguration, ValidatePayloadRequest}
import amf.xml.internal

/** Additional properties could cause ambiguity error in some validation cases, so it can be disabled */
case class XmlValidationPlugin() extends AMFShapePayloadValidationPlugin {

  private val mediaTypes = Seq("application/xml", "application/amf+xml")

  override val id: String = "XML Validation Plugin"

  override def applies(element: ValidatePayloadRequest): Boolean = mediaTypes.contains(element.mediaType)


  override def validator(shape: Shape, mediaType: String, config: ShapeValidationConfiguration, validationMode: ValidationMode): AMFShapePayloadValidator = {
    internal.XmlPayloadValidator(shape, config, validationMode)
  }
}
