package amf.xml.internal.transformer

import amf.core.client.scala.model.domain.Shape
import amf.core.internal.annotations.AutoGeneratedName
import amf.xml.internal.transformer.vistors.TypeToXmlSchemaVisitor
import amf.xml.internal.util.XmlUtils.schemaToString
import amf.shapes.client.scala.model.domain._
import amf.shapes.internal.domain.metamodel.AnyShapeModel.XMLSerialization
import org.apache.ws.commons.schema.XmlSchemaForm.QUALIFIED
import org.apache.ws.commons.schema.{XmlSchema, XmlSchemaCollection}

object TypeToXmlSchema {
  def transform(name: String, shape: Shape): XmlSchema = {
    val visitor = createVisitor(shape)
    visitor.transformShape(name, shape)
    visitor.schema
  }

  def getTargetNamespace(shape: Shape): Option[String] = {
    shape match {
      case _: SchemaShape => None
      case any: AnyShape =>
        val xmlSerialization = any.fields.entry(XMLSerialization).map(_ => any.xmlSerialization)
        xmlSerialization match {
          case Some(x) => Some(x.namespace.value())
          case None => Some("http://amf-xml-extension/")
        }
      case _ =>
        throw new RuntimeException("Unsupported Shape")
    }
  }

  private[xml] def getSchemaAsString(anyShape: AnyShape): String = {
    anyShape match {
      case schemaShape: SchemaShape =>
        schemaShape.raw.value()
      case _ =>
        val schema = transform(rootElementName(anyShape), anyShape)
        schemaToString(schema)
    }
  }

  private def createVisitor(shape: Shape): TypeToXmlSchemaVisitor = {
    val collection = new XmlSchemaCollection()
    val target = getTargetNamespace(shape).get //This should never return None
    val schema = new XmlSchema(target, "api-xsd", collection)
    schema.setTargetNamespace(target)
    schema.setElementFormDefault(QUALIFIED)
    TypeToXmlSchemaVisitor(collection, schema)
  }

  private def rootElementName(shape: Shape): String = {
    shape match {
      case any: AnyShape =>
        val xmlSerialization =
          any.fields.entry(XMLSerialization).map(_ => any.xmlSerialization)
        xmlSerialization match {
          case Some(xml) => xml.name.value()
          case None =>
            any.annotations.find(classOf[AutoGeneratedName]) match {
              case Some(_) => "model"
              case None    => any.name.value()
            }
        }
      case s => s.name.value()
    }
  }
}

