package amf.xml.internal.util;

import java.util.concurrent.Callable;

public class ClassLoadingUtils {

  public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
    final Thread thread = Thread.currentThread();
    final ClassLoader currentClassLoader = thread.getContextClassLoader();
    if (currentClassLoader != classLoader) {
      thread.setContextClassLoader(classLoader);
    }
    try {
      return callable.call();
    } catch (Exception e) {
      throw new RuntimeException(e);
    } finally {
      if (currentClassLoader != classLoader) {
        thread.setContextClassLoader(currentClassLoader);
      }
    }
  }
}
