package amf.xml.internal.util

import java.io.{StringReader, StringWriter}

import org.apache.ws.commons.schema.XmlSchema
import org.xml.sax.helpers.XMLReaderFactory
import org.xml.sax.{InputSource, XMLReader}

object XmlUtils {

  private val ExternalEntitiesProperty = "amf.plugins.xml.expandExternalEntities"
  private val ExpandEntitiesProperty   = "amf.plugins.xml.expandInternalEntities"

  val AllowExternalEntities: Boolean = System.getProperty(ExternalEntitiesProperty, "false").toBoolean
  val ExpandEntities: Boolean        = System.getProperty(ExpandEntitiesProperty, "false").toBoolean

  val ExternalGeneralEntitiesFeature   = "http://xml.org/sax/features/external-general-entities"
  val ExternalParameterEntitiesFeature = "http://xml.org/sax/features/external-parameter-entities"
  val DisallowDoctypeDeclFeature       = "http://apache.org/xml/features/disallow-doctype-decl"

  /**
    * Create a new instance of XMLReader,
    *
    * @return an instance of XMLReader.
    */
  def createXMLReader: XMLReader = {
    val xmlReader = XMLReaderFactory.createXMLReader
    xmlReader.setFeature(DisallowDoctypeDeclFeature, !ExpandEntities)
    xmlReader.setFeature(ExternalGeneralEntitiesFeature, AllowExternalEntities)
    xmlReader.setFeature(ExternalParameterEntitiesFeature, AllowExternalEntities)
    xmlReader
  }

  /**
    * return true if the String passed in is something like XML
    *
    * @param value string that might be XML
    * @return true of the string is XML, false otherwise
    */
  def isXMLValue(value: String): Boolean = {
    try {
      val inputSource = new InputSource(new StringReader(value))
      val xmlReader = createXMLReader
      xmlReader.parse(inputSource)
      true
    } catch {
      case _: Exception => false
    }
  }

  def schemaToString(xmlSchema: XmlSchema): String = {
    val xsd = new StringWriter
    xmlSchema.write(xsd)
    xsd.toString
  }

}
