package ang.umi

import amf.core.client.ExitCodes
import ang.umi.commands.{CommandParser, PopulateCommand, ParserConfig}
import ang.umi.common.{AppConst, AppMessage, NoPopulation, PopulationDone}
import ang.umi.report.Report
import org.mulesoft.common.io.{Fs, SyncFile}

import scala.concurrent.ExecutionContext.Implicits.global
import scala.util.{Failure, Success}

object Main extends App with AppConst {

  final private val report = new Report()
  private var finish       = false // hack not to write 2 times on file when finish

  try {
    CommandParser.parse(args) match {
      case Some(cfg) =>
        // When process is killed, it will write in file all the actual progress
        sys.addShutdownHook {
          if (!finish) Report.writeInFile(getSysFile(cfg), report)
        }

        PopulateCommand(cfg, report).execute() onComplete {
          case Success(appMessage) =>
            handleMessage(cfg, appMessage)
            System.exit(ExitCodes.Success)
          case Failure(e) =>
            println(e.getMessage)
            System.exit(ExitCodes.Exception)
        }
      case _ => System.exit(ExitCodes.WrongInvocation)
    }
  } catch {
    case e: Exception =>
      System.err.println(e.getMessage)
      System.exit(ExitCodes.Exception)
  }

  def getSysFile(cfg: ParserConfig): SyncFile = {
    val outputDir = cfg.output.get
    if (!outputDir.exists) outputDir.mkdir
    Fs.syncFile(outputDir, s"report")
  }

  private def handleMessage(cfg: ParserConfig, appMessage: AppMessage): Unit = {
    appMessage match {
      case PopulationDone() =>
        val f = getSysFile(cfg)
        Report.writeInFile(f, report)
        finish = true
        println("Population done!!!")
      case NoPopulation(m) =>
        println(s"No population: $m")
    }
  }
}
