package ang.umi.common

import java.io.{Closeable, FileNotFoundException, InputStream}
import scala.io.Source.fromInputStream
import scala.util.{Failure, Success, Try}

object FileManager {

  def getContent(path: String): String =
    readTextFileWithTry(getClass.getResourceAsStream(path)) match {
      case Success(v) => v
      case Failure(e) => throw new FileNotFoundException(path).initCause(e)
    }

  private def readTextFileWithTry(inputStream: InputStream): Try[String] = {
    Try {
      using(fromInputStream(inputStream)) { source =>
        source.mkString
      }
    }
  }

  private def using[A <: Closeable, B](resource: A)(f: A => B): B = {
    try f(resource)
    finally resource.close()
  }
}

