package ang.umi.report

import ang.umi.report.EventProtocol._
import org.mulesoft.common.io.SyncFile
import spray.json._

import scala.collection.mutable

class Report {

  protected val events: mutable.HashSet[Event] = new mutable.HashSet[Event]()

  def addEvent(e: Event): Unit = events.add(e)

  override def toString: String =
    events
      .groupBy(_.transactionId)
      .map(
        t =>
          JsObject(
            "id"     -> JsString(t._1.toString),
            "events" -> t._2.map(_.toJson).toList.toJson
        ))
      .toJson
      .prettyPrint
}

case class Event(transactionId: Long, dataType: String, data: String) {
  override def toString: String = s"$dataType: $data"
}

object Report {
  def writeInFile(file: SyncFile, r: Report): Unit = file.write(r.toString())
}
