package ang.umi.report

import ang.umi.report.TrackerStatus.{ENDED, STARTED, TrackerStatus}

import scala.collection.mutable

object RequestTracker {

  private val requests = mutable.HashMap.empty[Long, Trackee]

  def track(id: Long): Unit =
    requests.put(id, Trackee(System.currentTimeMillis(), STARTED))

  def endTrack(id: Long): Unit =
    requests
      .get(id)
      .foreach(trackee => requests.update(id, Trackee(System.currentTimeMillis() - trackee.time, ENDED)))

  def getTime(id: Long): Option[Long] = {
    val answer = requests.get(id).filter(_.status == ENDED).map(_.time)
    requests.remove(id) // to prevent map to grow
    answer
  }
}

sealed case class Trackee(time: Long, status: TrackerStatus)

object TrackerStatus extends Enumeration {
  type TrackerStatus = Value
  val STARTED, ENDED = Value
}
