package ang.umi.router

import akka.actor.{Actor, Props, Terminated}
import akka.routing
import akka.routing._
import ang.umi.worker.Worker
import ang.umi.worker.Worker.PostANG

class AppRouter(numberOfWorkers: Int) extends Actor {

  var router: routing.Router = {
    val routees = Vector.fill(numberOfWorkers) {
      val r = context.actorOf(Worker.props)
      context watch r
      ActorRefRoutee(r)
    }
    Router(RoundRobinRoutingLogic(), routees)
  }

  def receive: Receive = {
    case msg: PostANG ⇒
      router.route(msg, sender())

    case Terminated(a) ⇒
      println(s"Actor ${a.path.name} just died!")
      router = router.removeRoutee(a)
      val r = context.actorOf(Worker.props)
      context watch r
      router = router.addRoutee(r)
  }
}

object AppRouter {
  def props(numberOfWorkers: Int) = Props(new AppRouter(numberOfWorkers))
}
