package ang.umi.worker

import akka.actor.{Actor, Props}
import akka.http.scaladsl.model.{HttpHeader, HttpResponse}
import akka.http.scaladsl.{Http, HttpExt}
import akka.pattern._
import ang.umi.common.{AppConst, Request, TokenHolder}
import ang.umi.report.RequestTracker
import ang.umi.worker.Worker.{PostANG, PostANGResult}

import scala.concurrent.ExecutionContext.Implicits.global

class Worker extends Actor with AppConst {

  final private implicit val http: HttpExt = Http(context.system)

  override def receive: Receive = {
    case PostANG(url, content, index) =>
      val headers: List[HttpHeader] = TokenHolder.getTokenHeader.map(List(_)).getOrElse(List.empty)
      RequestTracker.track(index)
      Request
        .post(url, content, headers = headers)
        .map(r => {
          RequestTracker.endTrack(index)
          PostANGResult(index, r)
        })
        .pipeTo(sender)
  }
}

object Worker {
  def props: Props = Props(new Worker())

  case class PostANG(path: String, content: String, index: Long)

  case class PostANGResult(index: Long, response: HttpResponse)
}
