package ang.umi.common

import amf.Core
import amf.core.model.document.BaseUnit
import amf.core.remote.{Aml, Cache, Context}
import amf.core.services.RuntimeCompiler
import amf.core.unsafe.PlatformSecrets
import amf.internal.environment.Environment
import amf.internal.resource.StringResourceLoader
import amf.plugins.document.Vocabularies
import amf.plugins.document.vocabularies.AMLPlugin
import amf.plugins.features.AMFValidation

import scala.concurrent.Future

trait AmfOps extends PlatformSecrets {

  Vocabularies.register()
  AMFValidation.register()
  Core.registerPlugin(AMLPlugin)
  Core.init().get

  def parse(url: String, content: String): Future[BaseUnit] = {
    RuntimeCompiler(
      url,
      Some("application/yaml"),
      Some(Aml.name),
      Context(platform),
      cache = Cache(),
      env = Environment().add(StringResourceLoader(url, content))
    )
  }
}
