package ang.umi.common

import akka.http.scaladsl.model.{HttpCharsets, HttpRequest, MediaType, MediaTypes}

object KnownMediaTypes {

  val `application/ld+json`: MediaType.WithFixedCharset =
    MediaType.applicationWithFixedCharset("ld+json", HttpCharsets.`UTF-8`)
  val `application/raml`: MediaType.WithFixedCharset =
    MediaType.applicationWithFixedCharset("raml", HttpCharsets.`UTF-8`)
  val `application/yaml`: MediaType.WithFixedCharset =
    MediaType.applicationWithFixedCharset("yaml", HttpCharsets.`UTF-8`)
  val `text/turtle`: MediaType.WithFixedCharset = MediaType.textWithFixedCharset("turtle", HttpCharsets.`UTF-8`)

  def parse(mediaType: String): Option[MediaType] = {
    MediaType.parse(mediaType).toOption.filter {
      _ match {
        case KnownMediaTypes.`application/ld+json` | KnownMediaTypes.`application/raml` |
             KnownMediaTypes.`application/yaml` | KnownMediaTypes.`text/turtle` | MediaTypes.`application/json` =>
          true
        case _ => false
      }
    }
  }

  def extractMediaType(request: HttpRequest): MediaType = {
    val contentType = request.entity.contentType.toString()
    KnownMediaTypes.parse(contentType).getOrElse(throw new RuntimeException(contentType.toString))
  }
}

