package ang.umi.report

import akka.http.scaladsl.model.HttpResponse
import ang.umi.common.Lap
import org.mulesoft.common.io.SyncFile

import scala.collection.mutable
import scala.util.{Failure, Success, Try}

case class Report(var success: Int, var failed: Int, var durations: mutable.Seq[Double]) {

  def lap(l: (Try[HttpResponse], Lap)): Report = l match {
    case (response: Try[HttpResponse], lap) =>
      durations = durations :+ lap.elapsed
      response match {
        case Success(r) if r.status.isSuccess() => success += 1
        case Success(_) | Failure(_)            => failed += 1
      }
      this
  }

  override def toString: String = PerformanceStat("Results", durations.toList, success, failed).getAggregateReport
}

object Report {
  def writeInFile(file: SyncFile, r: Report): Unit = file.write(r.toString())
  def apply(): Report                              = new Report(0, 0, mutable.Seq.empty)
}
