package ang.umi.common

import akka.actor.ActorSystem
import akka.http.scaladsl.Http
import akka.http.scaladsl.model.{HttpRequest, HttpResponse}
import akka.http.scaladsl.settings.ConnectionPoolSettings
import akka.stream.scaladsl.Flow

import scala.util.Try

sealed trait Connection {

  def settings(concurrency: Int)(implicit system: ActorSystem): ConnectionPoolSettings =
    ConnectionPoolSettings(system).withMaxConnections(concurrency).withMaxOpenRequests(concurrency)

  def biggestPowerOf2(value: Int): Int = {
    val highestOneBit = Integer.highestOneBit(value)
    if (value == highestOneBit) value
    else highestOneBit << 1
  }
}

object HttpConnection extends Connection {

  def connection[T](host: String, port: Int = 80, concurrency: Int = 32)(
      implicit system: ActorSystem): Flow[(HttpRequest, T), (Try[HttpResponse], T), Http.HostConnectionPool] =
    Http().cachedHostConnectionPool[T](host, port, settings = settings(biggestPowerOf2(concurrency)))

  def secureConnection[T](host: String, concurrency: Int = 32)(
      implicit system: ActorSystem): Flow[(HttpRequest, T), (Try[HttpResponse], T), Http.HostConnectionPool] =
    Http().cachedHostConnectionPoolHttps[T](host, settings = settings(biggestPowerOf2(concurrency)))
}
