package ang.umi.common

import akka.http.scaladsl.HttpExt
import akka.http.scaladsl.model.ContentType.NonBinary
import akka.http.scaladsl.model._
import akka.http.scaladsl.model.headers.Accept
import ang.umi.common.KnownContentTypes.`application/yaml`

import scala.concurrent.Future

object Request {

  def post(url: String,
           content: String,
           contentType: NonBinary = `application/yaml`,
           headers: List[HttpHeader] = List.empty)(implicit http: HttpExt): Future[HttpResponse] = {
    http.singleRequest(HttpRequest(HttpMethods.POST, url).withEntity(contentType, content).withHeaders(headers))
  }

  def put(url: String,
          content: String,
          contentType: NonBinary = `application/yaml`,
          headers: List[HttpHeader] = List.empty)(implicit http: HttpExt): Future[HttpResponse] = {
    http.singleRequest(
      HttpRequest(HttpMethods.PUT, url).withEntity(contentType, content).withHeaders(headers)
    )
  }

  def delete(url: String)(implicit http: HttpExt): Future[HttpResponse] = {
    http.singleRequest(HttpRequest(HttpMethods.DELETE, url))
  }

  def get(uri: String, mediaType: MediaType.NonBinary, additionalHeaders: List[HttpHeader] = List.empty)(
      implicit http: HttpExt): Future[HttpResponse] = {
    http.singleRequest(
      HttpRequest(HttpMethods.GET, uri).withHeaders(additionalHeaders :+ Accept(MediaRange(mediaType))))
  }
}
