/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.cxf.CXFInvocationHandler;
import org.apache.cxf.jca.cxf.CXFInvocationHandlerData;

abstract class CXFInvocationHandlerBase
implements CXFInvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFInvocationHandlerBase.class);
    private CXFInvocationHandler next;
    private CXFInvocationHandlerData data;

    public CXFInvocationHandlerBase(CXFInvocationHandlerData cihd) {
        this.data = cihd;
    }

    @Override
    public void setNext(CXFInvocationHandler cih) {
        this.next = cih;
    }

    @Override
    public CXFInvocationHandler getNext() {
        return this.next;
    }

    @Override
    public CXFInvocationHandlerData getData() {
        return this.data;
    }

    protected Object invokeNext(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        if (this.getNext() != null) {
            ret = this.getNext().invoke(proxy, method, args);
        } else {
            LOG.fine("no more invocation handler");
        }
        return ret;
    }

    protected Throwable getExceptionToThrow(InvocationTargetException ex, Method targetMethod) throws Throwable {
        Throwable targetException = ex.getTargetException();
        Throwable ret = null;
        if (this.isOkToThrow(targetMethod, targetException)) {
            ret = targetException;
        } else {
            RuntimeException re = new RuntimeException("Unexpected exception from method " + targetMethod, targetException);
            ret = re;
        }
        return ret;
    }

    private boolean isOkToThrow(Method method, Throwable t) {
        return t instanceof RuntimeException || this.isCheckedException(method, t);
    }

    private boolean isCheckedException(Method method, Throwable t) {
        boolean isCheckedException = false;
        Class<?>[] checkExceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < checkExceptionTypes.length; ++i) {
            if (!checkExceptionTypes[i].isAssignableFrom(t.getClass())) continue;
            isCheckedException = true;
            break;
        }
        return isCheckedException;
    }
}

