/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.javatowadl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class Java2WADLMojo
extends AbstractMojo {
    public static final String WADL_NS = "http://wadl.dev.java.net/2009/02";
    private List<ClassResourceInfo> classResourceInfos = new ArrayList<ClassResourceInfo>();
    private String outputFile;
    private String address;
    private Boolean attachWadl;
    private String classifier;
    private List<String> classResourceNames;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private boolean useJson;
    private boolean singleResourceMultipleMethods;
    private boolean useSingleSlashResource;
    private boolean ignoreForwardSlash;
    private boolean addResourceAndMethodIds;
    private boolean linkAnyMediaTypeToXmlSchema;
    private String applicationTitle;
    private String namespacePrefix;

    public void execute() throws MojoExecutionException {
        this.getResourcesList();
        WadlGenerator wadlGenerator = new WadlGenerator(this.getBus());
        this.setExtraProperties(wadlGenerator);
        StringBuilder sbMain = wadlGenerator.generateWADL(this.getBaseURI(), this.classResourceInfos, this.useJson, null, null);
        this.getLog().debug((CharSequence)("the wadl is =====> \n" + sbMain.toString()));
        this.generateWadl(sbMain.toString());
    }

    private void setExtraProperties(WadlGenerator wg) {
        wg.setSingleResourceMultipleMethods(this.singleResourceMultipleMethods);
        wg.setUseSingleSlashResource(this.useSingleSlashResource);
        wg.setIgnoreForwardSlash(this.ignoreForwardSlash);
        wg.setAddResourceAndMethodIds(this.addResourceAndMethodIds);
        wg.setLinkAnyMediaTypeToXmlSchema(this.linkAnyMediaTypeToXmlSchema);
        if (this.applicationTitle != null) {
            wg.setApplicationTitle(this.applicationTitle);
        }
        if (this.namespacePrefix != null) {
            wg.setNamespacePrefix(this.namespacePrefix);
        }
    }

    private void generateWadl(String wadl) throws MojoExecutionException {
        File wadlFile;
        if (this.outputFile == null && this.project != null) {
            String className = this.classResourceNames.get(0);
            int i = className.lastIndexOf(46);
            String name = className.substring(i + 1);
            this.outputFile = (this.project.getBuild().getDirectory() + "/generated/wadl/" + name + ".wadl").replace("/", File.separator);
        }
        BufferedWriter writer = null;
        try {
            FileUtils.mkDir((File)new File(this.outputFile).getParentFile());
            writer = new BufferedWriter(new FileWriter(this.outputFile));
            writer.write(wadl);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.attachWadl.booleanValue() && this.outputFile != null && (wadlFile = new File(this.outputFile)).exists()) {
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, "wadl", this.classifier, wadlFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "wadl", wadlFile);
            }
        }
    }

    private String getBaseURI() {
        if (this.address != null) {
            return this.address;
        }
        return "http://localhost/cxf/";
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            URL[] runtimeUrls = new URL[runtimeClasspathElements.size()];
            for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
                String element = (String)runtimeClasspathElements.get(i);
                runtimeUrls[i] = new File(element).toURI().toURL();
            }
            URLClassLoader newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
            return newLoader;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void getResourcesList() throws MojoExecutionException {
        for (String className : this.classResourceNames) {
            Object bean = null;
            try {
                bean = this.getClassLoader().loadClass(className).newInstance();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            Class realClass = ClassHelper.getRealClass(bean);
            ClassResourceInfo cri = this.getCreatedFromModel(realClass);
            if (cri != null) {
                if (!InjectionUtils.isConcreteClass((Class)cri.getServiceClass())) {
                    cri = new ClassResourceInfo(cri);
                    this.classResourceInfos.add(cri);
                }
                cri.setResourceClass(bean.getClass());
                cri.setResourceProvider((ResourceProvider)new SingletonResourceProvider(bean));
                continue;
            }
            cri = ResourceUtils.createClassResourceInfo(bean.getClass(), (Class)realClass, (boolean)true, (boolean)true, (Bus)this.getBus());
            if (cri == null) continue;
            this.classResourceInfos.add(cri);
            cri.setResourceProvider((ResourceProvider)new SingletonResourceProvider(bean));
        }
    }

    private Bus getBus() {
        return BusFactory.getDefaultBus();
    }

    private ClassResourceInfo getCreatedFromModel(Class<?> realClass) {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (!cri.isCreatedFromModel() || !cri.isRoot() || !cri.getServiceClass().isAssignableFrom(realClass)) continue;
            return cri;
        }
        return null;
    }
}

