/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.AbstractBaseBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.binding.xml.interceptor.XMLFaultOutInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor;
import org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.transport.Destination;

@NoJSR250Annotations(unlessNull={"bus"})
public class JAXRSBindingFactory
extends AbstractBaseBindingFactory {
    public static final String JAXRS_BINDING_ID = "http://apache.org/cxf/binding/jaxrs";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSBindingFactory.class);

    public JAXRSBindingFactory() {
    }

    public JAXRSBindingFactory(Bus b) {
        super(b);
    }

    public Binding createBinding(BindingInfo bi) {
        XMLBinding binding = new XMLBinding(bi);
        binding.getInInterceptors().add(new JAXRSInInterceptor());
        binding.getOutInterceptors().add(new JAXRSOutInterceptor());
        binding.getOutFaultInterceptors().add(new XMLFaultOutInterceptor());
        binding.getOutFaultInterceptors().add(new StaxOutInterceptor());
        return binding;
    }

    public BindingInfo createBindingInfo(Service service, String namespace, Object obj) {
        BindingInfo info = new BindingInfo(null, JAXRS_BINDING_ID);
        info.setName(new QName(JAXRS_BINDING_ID, "binding"));
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Destination d, Endpoint e) {
        Destination destination = d;
        synchronized (destination) {
            if (d.getMessageObserver() != null) {
                throw new ServiceConstructionException(new Message("ALREADY_RUNNING", LOG, new Object[]{e.getEndpointInfo().getAddress()}));
            }
            super.addListener(d, e);
        }
    }
}

