/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.settings;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.event.ChangedSubscriptionsEvent;
import org.apache.cxf.management.web.browser.client.event.GoToBrowserEvent;
import org.apache.cxf.management.web.browser.client.service.settings.SettingsFacade;
import org.apache.cxf.management.web.browser.client.service.settings.Subscription;
import org.apache.cxf.management.web.browser.client.ui.BasePresenter;
import org.apache.cxf.management.web.browser.client.ui.BindStrategy;
import org.apache.cxf.management.web.browser.client.ui.common.NavigationHeaderPresenter;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserConstans;
import org.apache.cxf.management.web.browser.client.ui.settings.SettingsView;
import org.apache.cxf.management.web.browser.client.ui.settings.SubscriptionDialog;

@Singleton
public class SettingsPresenter
extends BasePresenter
implements SettingsView.Presenter,
SubscriptionDialog.Presenter {
    @Nonnull
    private final SettingsView view;
    @Nonnull
    private final SettingsFacade settingsFacade;
    @Nonnull
    private final SubscriptionDialog subscriptionDialog;
    @Nonnull
    private final LogBrowserConstans constans;

    @Inject
    public SettingsPresenter(@Nonnull EventBus eventBus, @Nonnull SettingsView view, @Nonnull @Named(value="BindStrategyForSettings") BindStrategy bindStrategy, @Nonnull NavigationHeaderPresenter navigationHeaderPresenter, @Nonnull SettingsFacade settingsFacade, @Nonnull SubscriptionDialog subscriptionDialog, @Nonnull LogBrowserConstans constans) {
        super(eventBus, view, bindStrategy);
        this.view = view;
        this.settingsFacade = settingsFacade;
        this.subscriptionDialog = subscriptionDialog;
        this.constans = constans;
        this.view.setPresenter(this);
        this.subscriptionDialog.setPresenter(this);
        navigationHeaderPresenter.go(view.getNaviagationHeaderSlot());
        this.updateSubscriptions();
    }

    @Override
    public void go(@Nonnull HasWidgets container) {
        container.clear();
        container.add(this.view.asWidget());
    }

    @Override
    public void onAddSubscriptionButtonClicked() {
        this.showSubscriptionDialog(this.constans.settingsTabAddSubscriptionDialogTitle(), null);
    }

    @Override
    public void onEditSubscriptionButtonClicked(@Nonnull Subscription subscription) {
        this.showSubscriptionDialog(this.constans.settingsTabEditSubscriptionDialogTitle(), subscription);
    }

    @Override
    public void onRemoveSubscriptionButtonClicked(@Nonnull Subscription subscription) {
        this.settingsFacade.removeSubscription(subscription);
        this.updateSubscriptions();
    }

    @Override
    public void onSaveButtonClicked(@Nullable String id, @Nonnull HasValue<String> name, @Nonnull HasValue<String> url) {
        Map<HasValue<String>, String> errors = this.validate(name, url);
        if (errors.isEmpty()) {
            String nameValue = (String)name.getValue();
            String urlValue = (String)url.getValue();
            if (id == null) {
                this.settingsFacade.addSubscription(nameValue, urlValue);
            } else {
                this.settingsFacade.updateSubscription(new Subscription(id, nameValue, urlValue));
            }
            this.updateSubscriptions();
            this.subscriptionDialog.hide();
        } else {
            this.subscriptionDialog.setValidationErrors(errors);
        }
    }

    @Override
    public void onCancelButtonClicked() {
        this.subscriptionDialog.hide();
    }

    @Override
    public void onBackHyperlinkClicked() {
        this.eventBus.fireEvent((GwtEvent)new GoToBrowserEvent());
    }

    private void updateSubscriptions() {
        this.eventBus.fireEvent((GwtEvent)new ChangedSubscriptionsEvent());
        this.view.setData(this.settingsFacade.getSubscriptions());
    }

    private void showSubscriptionDialog(@Nonnull String title, @Nullable Subscription data) {
        this.subscriptionDialog.setTitle(title);
        this.subscriptionDialog.setData(data);
        this.subscriptionDialog.setValidationErrors(null);
        this.subscriptionDialog.center();
        this.subscriptionDialog.show();
    }

    private Map<HasValue<String>, String> validate(@Nonnull HasValue<String> name, @Nonnull HasValue<String> url) {
        String urlValue;
        HashMap<HasValue<String>, String> errors = new HashMap<HasValue<String>, String>();
        String nameValue = (String)name.getValue();
        if (nameValue == null || nameValue.length() == 0) {
            errors.put(name, this.constans.settingsTabSubscriptionDialogEmptyName());
        }
        if ((urlValue = (String)url.getValue()) == null || urlValue.length() == 0) {
            errors.put(url, this.constans.settingsTabSubscriptionDialogEmptyUrl());
        }
        return errors;
    }
}

