/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.cxf.jaxrs.ext.search.client.SearchConditionBuilder;
import org.apache.cxf.jaxrs.ext.search.fiql.FiqlParser;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class SearchContextImpl
implements SearchContext {
    public static final String SEARCH_QUERY = "_search";
    public static final String SHORT_SEARCH_QUERY = "_s";
    public static final String CUSTOM_SEARCH_QUERY_PARAM_NAME = "search.query.parameter.name";
    private static final String USE_PLAIN_QUERY_PARAMETERS = "search.use.plain.queries";
    private static final String USE_ALL_QUERY_COMPONENT = "search.use.all.query.component";
    private static final String BLOCK_SEARCH_EXCEPTION = "search.block.search.exception";
    private static final String KEEP_QUERY_ENCODED = "search.keep.query.encoded";
    private static final Logger LOG = LogUtils.getL7dLogger(SearchContextImpl.class);
    private Message message;

    public SearchContextImpl(Message message) {
        this.message = message;
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls) {
        return this.getCondition(null, cls);
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls, Map<String, String> beanProperties) {
        return this.getCondition(null, cls, beanProperties);
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls, Map<String, String> beanProperties, Map<String, String> parserProperties) {
        return this.getCondition(null, cls, beanProperties, parserProperties);
    }

    @Override
    public <T> SearchCondition<T> getCondition(String expression, Class<T> cls) {
        return this.getCondition(expression, cls, null);
    }

    @Override
    public <T> SearchCondition<T> getCondition(String expression, Class<T> cls, Map<String, String> beanProperties) {
        return this.getCondition(expression, cls, beanProperties, null);
    }

    @Override
    public <T> SearchCondition<T> getCondition(String expression, Class<T> cls, Map<String, String> beanProperties, Map<String, String> parserProperties) {
        String theExpression;
        if (InjectionUtils.isPrimitive(cls)) {
            String errorMessage = "Primitive condition types are not supported";
            LOG.warning(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        SearchConditionParser<T> parser = this.getParser(cls, beanProperties, parserProperties);
        String string = theExpression = expression == null ? this.getSearchExpression() : expression;
        if (theExpression != null) {
            try {
                return parser.parse(theExpression);
            }
            catch (SearchParseException ex) {
                Object prop = this.message.getContextualProperty(BLOCK_SEARCH_EXCEPTION);
                if (prop != null && !PropertyUtils.isTrue((Object)prop)) {
                    throw ex;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSearchExpression() {
        String queryStr = (String)this.message.get((Object)Message.QUERY_STRING);
        if (queryStr != null) {
            if (MessageUtils.isTrue((Object)this.message.getContextualProperty(USE_ALL_QUERY_COMPONENT))) {
                return queryStr;
            }
            boolean encoded = PropertyUtils.isTrue((Object)this.getKeepEncodedProperty());
            MultivaluedMap params = JAXRSUtils.getStructuredParams((String)queryStr, (String)"&", (!encoded ? 1 : 0) != 0, (boolean)false);
            String customQueryParamName = (String)this.message.getContextualProperty(CUSTOM_SEARCH_QUERY_PARAM_NAME);
            if (customQueryParamName != null) {
                return (String)params.getFirst((Object)customQueryParamName);
            }
            if (queryStr.contains(SHORT_SEARCH_QUERY) || queryStr.contains(SEARCH_QUERY)) {
                if (params.containsKey((Object)SHORT_SEARCH_QUERY)) {
                    return (String)params.getFirst((Object)SHORT_SEARCH_QUERY);
                }
                return (String)params.getFirst((Object)SEARCH_QUERY);
            }
            if (MessageUtils.isTrue((Object)this.message.getContextualProperty(USE_PLAIN_QUERY_PARAMETERS))) {
                return this.convertPlainQueriesToFiqlExp((MultivaluedMap<String, String>)params);
            }
        }
        return null;
    }

    private String convertPlainQueriesToFiqlExp(MultivaluedMap<String, String> params) {
        SearchConditionBuilder builder = SearchConditionBuilder.instance();
        ArrayList<CompleteCondition> list = new ArrayList<CompleteCondition>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            list.add(this.getOrCondition(builder, entry));
        }
        return builder.and(list).query();
    }

    private String getKeepEncodedProperty() {
        return (String)this.message.getContextualProperty(KEEP_QUERY_ENCODED);
    }

    private CompleteCondition getOrCondition(SearchConditionBuilder builder, Map.Entry<String, List<String>> entry) {
        String key = entry.getKey();
        ConditionType ct = null;
        if (key.endsWith("From")) {
            ct = ConditionType.GREATER_OR_EQUALS;
            key = key.substring(0, key.length() - 4);
        } else if (key.endsWith("Till")) {
            ct = ConditionType.LESS_OR_EQUALS;
            key = key.substring(0, key.length() - 4);
        } else {
            ct = ConditionType.EQUALS;
        }
        ArrayList<CompleteCondition> list = new ArrayList<CompleteCondition>(entry.getValue().size());
        for (String value : entry.getValue()) {
            list.add(builder.is(key).comparesTo(ct, value));
        }
        return builder.or(list);
    }

    private <T> SearchConditionParser<T> getParser(Class<T> cls, Map<String, String> beanProperties, Map<String, String> parserProperties) {
        Map<String, String> props = null;
        if (parserProperties == null) {
            props = new LinkedHashMap<String, String>(4);
            props.put("search.date-format", (String)this.message.getContextualProperty("search.date-format"));
            props.put("search.timezone.support", (String)this.message.getContextualProperty("search.timezone.support"));
            props.put("search.lax.property.match", (String)this.message.getContextualProperty("search.lax.property.match"));
            props.put("search.decode.values", (String)this.message.getContextualProperty("search.decode.values"));
            props.put("fiql.support.single.equals.operator", (String)this.message.getContextualProperty("fiql.support.single.equals.operator"));
        } else {
            props = parserProperties;
        }
        Map beanProps = null;
        beanProps = beanProperties == null ? CastUtils.cast((Map)((Map)this.message.getContextualProperty("search.bean.property.map"))) : beanProperties;
        return new FiqlParser<T>(cls, props, beanProps);
    }
}

