/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.saml.sso.AbstractRequestAssertionConsumerHandler;

@PreMatching
@BindingPriority(value=2000)
public class RequestAssertionConsumerFilter
extends AbstractRequestAssertionConsumerHandler
implements ContainerRequestFilter {
    private boolean supportPostBinding;

    public void filter(ContainerRequestContext ct) throws IOException {
        String strForm;
        MultivaluedMap params;
        String httpMethod = ct.getMethod();
        if ("GET".equals(httpMethod) && !this.supportPostBinding) {
            MultivaluedMap params2 = ct.getUriInfo().getQueryParameters();
            this.processParams(ct, (MultivaluedMap<String, String>)params2, false);
        } else if ("POST".equals(httpMethod) && this.supportPostBinding && MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(ct.getMediaType()) && !this.processParams(ct, (MultivaluedMap<String, String>)(params = JAXRSUtils.getStructuredParams((String)(strForm = IOUtils.toString((InputStream)ct.getEntityStream())), (String)"&", (boolean)false, (boolean)false)), true)) {
            ct.setEntityStream((InputStream)new ByteArrayInputStream(strForm.getBytes()));
        }
    }

    protected boolean processParams(ContainerRequestContext ct, MultivaluedMap<String, String> params, boolean postBinding) {
        String encodedSamlResponse = (String)params.getFirst((Object)"SAMLResponse");
        String relayState = (String)params.getFirst((Object)"RelayState");
        if (relayState == null && encodedSamlResponse == null) {
            JAXRSUtils.getCurrentMessage().put((Object)"org.apache.cxf.racs.is.collocated", (Object)Boolean.TRUE);
            return false;
        }
        ct.abortWith(this.doProcessSamlResponse(encodedSamlResponse, relayState, postBinding));
        return true;
    }

    public void setSupportPostBinding(boolean supportPostBinding) {
        this.supportPostBinding = supportPostBinding;
    }
}

