/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.w3c.dom.Element;

public class JavaInterface
implements JavaAnnotatable {
    private String name;
    private String packageName;
    private String namespace;
    private String location;
    private String packageJavaDoc;
    private String classJavaDoc;
    private JavaModel model;
    private SOAPBinding.Style soapStyle;
    private SOAPBinding.Use soapUse;
    private SOAPBinding.ParameterStyle soapParameterStyle;
    private final List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private final List<JAnnotation> annotations = new ArrayList<JAnnotation>();
    private final Set<String> imports = new TreeSet<String>();
    private String webserviceName;
    private Element handlerChains;

    public JavaInterface() {
    }

    public JavaInterface(JavaModel m) {
        this.model = m;
    }

    static String formatJavaDoc(String d, String spaces) {
        if (d != null) {
            StringBuilder d2 = new StringBuilder(d.length());
            StringReader r = new StringReader(d);
            BufferedReader r2 = new BufferedReader(r);
            try {
                String s2 = r2.readLine();
                String pfx = null;
                while (s2 != null) {
                    if (pfx == null && s2.length() > 0) {
                        pfx = "";
                        while (s2.length() > 0 && Character.isWhitespace(s2.charAt(0))) {
                            pfx = pfx + " ";
                            s2 = s2.substring(1);
                        }
                    }
                    if (pfx != null) {
                        if (d2.length() > 0) {
                            d2.append("\n");
                        }
                        d2.append(spaces).append("* ");
                        if (s2.startsWith(pfx)) {
                            d2.append(s2.substring(pfx.length()));
                        } else {
                            d2.append(s2);
                        }
                    }
                    s2 = r2.readLine();
                }
                d = d2.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return d;
    }

    public void setWebServiceName(String wsn) {
        this.webserviceName = wsn;
    }

    public String getWebServiceName() {
        return this.webserviceName;
    }

    public void setSOAPStyle(SOAPBinding.Style s) {
        this.soapStyle = s;
    }

    public SOAPBinding.Style getSOAPStyle() {
        return this.soapStyle;
    }

    public void setSOAPUse(SOAPBinding.Use u) {
        this.soapUse = u;
    }

    public SOAPBinding.Use getSOAPUse() {
        return this.soapUse;
    }

    public void setSOAPParameterStyle(SOAPBinding.ParameterStyle p) {
        this.soapParameterStyle = p;
    }

    public SOAPBinding.ParameterStyle getSOAPParameterStyle() {
        return this.soapParameterStyle;
    }

    public JavaModel getJavaModel() {
        return this.model;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String l) {
        this.location = l;
    }

    public String getLocation() {
        return this.location;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public boolean hasMethod(JavaMethod method) {
        if (method != null) {
            String signature = method.getSignature();
            for (int i = 0; i < this.methods.size(); ++i) {
                if (!signature.equals(this.methods.get(i).getSignature())) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOf(JavaMethod method) {
        if (method != null) {
            String signature = method.getSignature();
            for (int i = 0; i < this.methods.size(); ++i) {
                if (!signature.equals(this.methods.get(i).getSignature())) continue;
                return i;
            }
        }
        return -1;
    }

    public int removeMethod(JavaMethod method) {
        int index = this.indexOf(method);
        if (index > -1) {
            this.methods.remove(index);
        }
        return index;
    }

    public void replaceMethod(JavaMethod method) {
        int index = this.removeMethod(method);
        this.methods.add(index, method);
    }

    public void addMethod(JavaMethod method) throws ToolException {
        if (this.hasMethod(method)) {
            this.replaceMethod(method);
        } else {
            this.methods.add(method);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String pn) {
        this.packageName = pn;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public void setPackageJavaDoc(String doc) {
        this.packageJavaDoc = JavaInterface.formatJavaDoc(doc, " ");
    }

    public String getPackageJavaDoc() {
        return this.packageJavaDoc != null ? this.packageJavaDoc : "";
    }

    public void setClassJavaDoc(String doc) {
        this.classJavaDoc = JavaInterface.formatJavaDoc(doc, " ");
    }

    public String getClassJavaDoc() {
        return this.classJavaDoc != null ? this.classJavaDoc : "";
    }

    public void addAnnotation(JAnnotation annotation) {
        this.annotations.add(annotation);
        for (String importClz : annotation.getImports()) {
            this.addImport(importClz);
        }
    }

    public List<JAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addImport(String i) {
        if (i != null && i.lastIndexOf(".") != -1 && this.getPackageName() != null && this.getPackageName().equals(i.substring(0, i.lastIndexOf(".")))) {
            return;
        }
        if (i != null) {
            this.imports.add(i.replaceAll("\\$", "\\."));
        }
    }

    public void addImports(Collection<String> ii) {
        for (String i : ii) {
            this.imports.add(i.replaceAll("\\$", "\\."));
        }
    }

    public Iterator<String> getImports() {
        return this.imports.iterator();
    }

    public void setJavaModel(JavaModel jm) {
        this.model = jm;
    }

    @Override
    public void annotate(Annotator annotator) {
        annotator.annotate(this);
    }

    public Element getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(Element elem) {
        this.handlerChains = elem;
    }

    public void setFullClassName(String fullName) {
        int index = fullName.lastIndexOf(".");
        this.setPackageName(fullName.substring(0, index));
        this.setName(fullName.substring(index + 1, fullName.length()));
    }

    public String getFullClassName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPackageName());
        sb.append(".");
        sb.append(this.getName());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (JAnnotation anno : this.annotations) {
            sb.append(anno);
            sb.append("\n");
        }
        sb.append(this.getFullClassName());
        return sb.toString();
    }
}

