/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SOAPBindingUtil;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBinding;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBody;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapFault;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapOperation;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.misc.processor.AbstractWSDLToProcessor;

public class WSDLToSoapProcessor
extends AbstractWSDLToProcessor {
    private static final String NEW_FILE_NAME_MODIFIER = "-soapbinding";
    private Map<QName, PortType> portTypes;
    private PortType portType;
    private Binding binding;

    @Override
    public void process() throws ToolException {
        this.init();
        this.validate();
        this.doAppendBinding();
    }

    private boolean isSOAP12() {
        return this.env.optionSet("soap12");
    }

    private void validate() throws ToolException {
        if (this.isBindingExisted()) {
            Message msg = new Message("BINDING_ALREADY_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        if (!this.isPortTypeExisted()) {
            Message msg = new Message("PORTTYPE_NOT_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        if (!this.nameSpaceCheck()) {
            Message msg = new Message("SOAPBINDING_STYLE_NOT_PROVIDED", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        if ("rpc".equalsIgnoreCase((String)this.env.get("style"))) {
            List ops = CastUtils.cast((List)this.portType.getOperations());
            for (Operation op : ops) {
                Output output;
                Input input = op.getInput();
                if (input != null && input.getMessage() != null) {
                    Collection parts = CastUtils.cast(input.getMessage().getParts().values());
                    for (Part part : parts) {
                        if (part.getTypeName() != null && !"".equals(part.getTypeName().toString())) continue;
                        Message msg = new Message("RPC_PART_ILLEGAL", LOG, new Object[]{part.getName()});
                        throw new ToolException(msg);
                    }
                }
                if ((output = op.getOutput()) == null || output.getMessage() == null) continue;
                Collection parts = CastUtils.cast(output.getMessage().getParts().values());
                for (Part part : parts) {
                    if (part.getTypeName() != null && !"".equals(part.getTypeName().toString())) continue;
                    Message msg = new Message("RPC_PART_ILLEGAL", LOG, new Object[]{part.getName()});
                    throw new ToolException(msg);
                }
            }
        }
    }

    private boolean isPortTypeExisted() {
        this.portTypes = CastUtils.cast((Map)this.wsdlDefinition.getPortTypes());
        if (this.portTypes == null) {
            return false;
        }
        for (QName existPortQName : this.portTypes.keySet()) {
            String existPortName = existPortQName.getLocalPart();
            if (!existPortName.equals(this.env.get("porttype"))) continue;
            this.portType = this.portTypes.get(existPortQName);
            break;
        }
        return this.portType != null;
    }

    private boolean isBindingExisted() {
        Map bindings = CastUtils.cast((Map)this.wsdlDefinition.getBindings());
        if (bindings == null) {
            return false;
        }
        for (QName existBindingQName : bindings.keySet()) {
            String existBindingName = existBindingQName.getLocalPart();
            String bindingName = (String)this.env.get("binding");
            if (!bindingName.equals(existBindingName)) continue;
            this.binding = (Binding)bindings.get(existBindingQName);
        }
        return this.binding != null;
    }

    private boolean nameSpaceCheck() {
        return !"rpc".equalsIgnoreCase((String)this.env.get("style")) || this.env.optionSet("namespace");
    }

    @Override
    protected void init() throws ToolException {
        this.parseWSDL((String)this.env.get("wsdlurl"));
    }

    private void doAppendBinding() throws ToolException {
        if (this.binding == null) {
            this.binding = this.wsdlDefinition.createBinding();
            this.binding.setQName(new QName(this.wsdlDefinition.getTargetNamespace(), (String)this.env.get("binding")));
            this.binding.setUndefined(false);
            this.binding.setPortType(this.portType);
        }
        this.setSoapBindingExtElement();
        this.addBindingOperation();
        this.wsdlDefinition.addBinding(this.binding);
        WSDLWriter wsdlWriter = this.wsdlFactory.newWSDLWriter();
        Writer outputWriter = this.getOutputWriter(NEW_FILE_NAME_MODIFIER);
        try {
            wsdlWriter.writeWSDL(this.wsdlDefinition, outputWriter);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_WRITE_WSDL", LOG, new Object[]{wse.getMessage()});
            throw new ToolException(msg);
        }
        try {
            outputWriter.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("PORTTYPE_NOT_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void setSoapBindingExtElement() throws ToolException {
        if (this.extReg == null) {
            this.extReg = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        SOAPBindingUtil.addSOAPNamespace((Definition)this.wsdlDefinition, (boolean)this.isSOAP12());
        SoapBinding soapBinding = null;
        try {
            soapBinding = SOAPBindingUtil.createSoapBinding((ExtensionRegistry)this.extReg, (boolean)this.isSOAP12());
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SOAPBINDING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        soapBinding.setStyle((String)this.env.get("style"));
        this.binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
    }

    private void addBindingOperation() throws ToolException {
        List ops = this.portType.getOperations();
        for (Operation op : ops) {
            BindingOperation bindingOperation = this.wsdlDefinition.createBindingOperation();
            this.setSoapOperationExtElement(bindingOperation);
            bindingOperation.setName(op.getName());
            if (op.getInput() != null) {
                bindingOperation.setBindingInput(this.getBindingInput(op.getInput()));
            }
            if (op.getOutput() != null) {
                bindingOperation.setBindingOutput(this.getBindingOutput(op.getOutput()));
            }
            if (op.getFaults() != null && op.getFaults().size() > 0) {
                this.addSoapFaults(op, bindingOperation);
            }
            bindingOperation.setOperation(op);
            this.binding.addBindingOperation(bindingOperation);
        }
    }

    private void setSoapOperationExtElement(BindingOperation bo) throws ToolException {
        if (this.extReg == null) {
            this.extReg = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        SoapOperation soapOperation = null;
        try {
            soapOperation = SOAPBindingUtil.createSoapOperation((ExtensionRegistry)this.extReg, (boolean)this.isSOAP12());
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SOAPBINDING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        soapOperation.setStyle((String)this.env.get("style"));
        soapOperation.setSoapActionURI("");
        bo.addExtensibilityElement((ExtensibilityElement)soapOperation);
    }

    private BindingInput getBindingInput(Input input) throws ToolException {
        BindingInput bi = this.wsdlDefinition.createBindingInput();
        bi.setName(input.getName());
        bi.addExtensibilityElement((ExtensibilityElement)this.getSoapBody(BindingInput.class));
        return bi;
    }

    private BindingOutput getBindingOutput(Output output) throws ToolException {
        BindingOutput bo = this.wsdlDefinition.createBindingOutput();
        bo.setName(output.getName());
        bo.addExtensibilityElement((ExtensibilityElement)this.getSoapBody(BindingOutput.class));
        return bo;
    }

    private SoapBody getSoapBody(Class<?> parent) throws ToolException {
        if (this.extReg == null) {
            this.extReg = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        SoapBody soapBody = null;
        try {
            soapBody = SOAPBindingUtil.createSoapBody((ExtensionRegistry)this.extReg, parent, (boolean)this.isSOAP12());
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SOAPBINDING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        soapBody.setUse((String)this.env.get("use"));
        if ("rpc".equalsIgnoreCase((String)this.env.get("style")) && this.env.optionSet("namespace")) {
            soapBody.setNamespaceURI((String)this.env.get("namespace"));
        }
        return soapBody;
    }

    private void addSoapFaults(Operation op, BindingOperation bindingOperation) throws ToolException {
        Map faults = CastUtils.cast((Map)op.getFaults());
        for (Fault fault : faults.values()) {
            BindingFault bf = this.wsdlDefinition.createBindingFault();
            bf.setName(fault.getName());
            this.setSoapFaultExtElement(bf);
            bindingOperation.addBindingFault(bf);
        }
    }

    private void setSoapFaultExtElement(BindingFault bf) throws ToolException {
        if (this.extReg == null) {
            this.extReg = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        SoapFault soapFault = null;
        try {
            soapFault = SOAPBindingUtil.createSoapFault((ExtensionRegistry)this.extReg, (boolean)this.isSOAP12());
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SOAPBINDING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        soapFault.setName(bf.getName());
        soapFault.setUse((String)this.env.get("use"));
        if ("rpc".equalsIgnoreCase((String)this.env.get("style")) && this.env.optionSet("namespace")) {
            soapFault.setNamespaceURI((String)this.env.get("namespace"));
        }
        bf.addExtensibilityElement((ExtensibilityElement)soapFault);
    }
}

