package org.mulesoft.apb.project.client.scala.dependency

import amf.core.client.scala.config.{CachedReference, UnitCache}
import amf.core.client.scala.model.document.BaseUnit

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

trait UnitCacheBuilder {
  def build(deps: Seq[DesignDependency]): UnitCache
}

object APBUnitCacheBuilder extends UnitCacheBuilder {
  override def build(deps: Seq[DesignDependency]): UnitCache = {
    APBUnitCache(deps.map(dep => ExchangeModulePathHandler.buildPath(dep.descriptor) -> dep.baseUnit).toMap)
  }
}

case class APBUnitCache(cache: Map[String, BaseUnit]) extends UnitCache {
  override def fetch(url: String): Future[CachedReference] = {
    val dependencyPath = ExchangeModulePathHandler(url).map(_.exchangePath).getOrElse(url)
    Future(CachedReference(dependencyPath, cache(dependencyPath).cloneUnit()))
  }
}
