package org.mulesoft.apb.project.client.scala.model

class DescriptorBuilder {
  private var main: String                         = ""
  private var name: String                         = ""
  private var groupId                              = ""
  private var assetId                              = ""
  private var version                              = ""
  private var base                                 = ""
  private var classifier: Option[String]           = None
  private var tags: Seq[String]                    = Seq.empty
  private var dependencies: Seq[ProjectDependency] = Seq.empty

  def withMain(main: String): this.type = {
    this.main = main
    this
  }

  private[apb] def withBase(base: String): this.type = {
    this.base = base
    this
  }

  def withName(name: String): this.type = {
    this.name = name
    this
  }
  def withGroupId(groupId: String): this.type = {
    this.groupId = groupId
    this
  }

  def withAssetId(assetId: String): this.type = {
    this.assetId = assetId
    this
  }

  def withVersion(version: String): this.type = {
    this.version = version
    this
  }

  def withClassifier(classifier: String): this.type = {
    this.classifier = Some(classifier)
    this
  }

  def withTag(tag: String): this.type = {
    this.tags = tags :+ tag
    this
  }

  def withDependency(scope: DependencyScope, groupId: String, assetId: String, version: String): this.type = {
    this.dependencies = dependencies :+ ProjectDependency(scope, Gav(groupId, assetId, version))
    this
  }

  def withDependencies(dependencies: Seq[ProjectDependency]): this.type = {
    this.dependencies = dependencies
    this
  }

  def withTags(tags: Seq[String]): this.type = {
    this.tags = tags
    this
  }

  def build(): ProjectDescriptor =
    ProjectDescriptor(if (base.nonEmpty) base + "/" + main else main,
                      name,
                      Gav(groupId, assetId, version),
                      classifier,
                      tags,
                      dependencies)
}
