package org.mulesoft.apb.project.internal.convert

import amf.apicontract.internal.convert.ApiBaseClientConverter
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.convert.{ClientInternalMatcher, InternalClientMatcher}
import org.mulesoft.apb.project.client.platform
import org.mulesoft.apb.project.client.scala.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.environment.{DependencyFetcher => ClientDependencyFetcher}
import org.mulesoft.apb.project.client.scala.model.{Gav, ProjectDependency, ProjectDescriptor}
import org.mulesoft.apb.project.client.platform.model.{ProjectDescriptor => ClientProjectDescriptor}
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency => ClientDesignDependency,
  ExtensionDependency => ClientExtensionDependency,
  ParsedDependency => ClientParsedDependency,
  ProfileDependency => ClientProfileDependency
}
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.platform.{ProjectConfiguration => ClientProjectConfiguration}

import scala.concurrent.{ExecutionContext, Future}

trait APBProjectConverters extends ApiBaseClientConverter {
  implicit class FutureListConverter[Internal, Client](from: Future[Seq[Internal]])(
      implicit m: InternalClientMatcher[Internal, Client],
      executionContext: ExecutionContext) {
    def asClient: ClientFuture[ClientList[Client]] = {
      asClientFuture(from.map(s => asClientList(s, m)))
    }
  }

  implicit object ProjectConfigurationClientConverter
      extends InternalClientMatcher[ProjectConfiguration, ClientProjectConfiguration] {
    override def asClient(from: ProjectConfiguration): ClientProjectConfiguration =
      new ClientProjectConfiguration(from)
  }

  implicit object DependencyFetcherConverter
      extends ClientInternalMatcher[ClientDependencyFetcher, DependencyFetcher] {
    override def asInternal(from: ClientDependencyFetcher): DependencyFetcher = new DependencyFetcher {
      override def accepts(groupId: String, assetId: String, version: String): Boolean =
        from.accepts(groupId, assetId, version)

      override def fetch(groupId: String, assetId: String, version: String): ResourceLoader = {
        ResourceLoaderMatcher.asInternal(from.fetch(groupId, assetId, version))(ExecutionContext.Implicits.global)
      }
    }
  }

  implicit object ParsedDependencyConverter extends InternalClientMatcher[ParsedDependency, ClientParsedDependency] {
    override def asClient(from: ParsedDependency): ClientParsedDependency = from match {
      case d: DesignDependency    => ClientDesignDependency(d)
      case e: ExtensionDependency => ClientExtensionDependency(e)
      case p: ProfileDependency   => ClientProfileDependency(p)
    }
  }

  implicit object ProjectDescriptorConverter
      extends InternalClientMatcher[ProjectDescriptor, ClientProjectDescriptor] {
    override def asClient(from: ProjectDescriptor): ClientProjectDescriptor = ClientProjectDescriptor(from)
  }

  implicit object GavMatcher extends InternalClientMatcher[Gav, Gav] {
    override def asClient(from: Gav): Gav = from
  }

  implicit object ProjectDependencyMatcher extends InternalClientMatcher[ProjectDependency, ProjectDependency] {
    override def asClient(from: ProjectDependency): ProjectDependency = from
  }
}

object APBProjectConverters extends APBProjectConverters
