package org.mulesoft.apb.project.internal

import org.yaml.model.YMap
import amf.core.internal.parser.YMapOps

package object parser {
  implicit class YMapLocalOps(map: YMap) extends YMapOps(map) {
    def stringValueFor(keyword: String, fn: String => Unit): Unit = {
      stringValueFor(keyword) foreach {
        fn
      }
    }

    def stringValueFor(keyword: String): Option[String] = {
      key(keyword).flatMap { e =>
        e.value.asScalar.map(_.text)
      }
    }
  }
}
