package org.mulesoft.apb.project.client.platform

import amf.apicontract.client.platform.AMFConfiguration
import amf.core.internal.remote.Spec
import org.mulesoft.apb.project.client.platform.dependency.ParsedDependency
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import org.mulesoft.apb.project.client.scala.{ ProjectConfiguration => InternalProjectConfiguration }

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class ProjectConfiguration private[apb] (private[apb] val _internal: InternalProjectConfiguration) {

  private[apb] lazy val parseConfig: AMFConfiguration = _internal.webApiParseConfig

  def configFor(spec: Spec): AMFConfiguration = _internal.configFor(spec)

  val allDependencies: ClientList[ParsedDependency] = _internal.allDependencies.asClient
}
