package org.mulesoft.apb.project.client.platform.model

import amf.apicontract.internal.convert.ApiClientConverters.{ClientList, ClientOption}
import org.mulesoft.apb.project.client.scala.model.{Gav, ProjectDependency}
import org.mulesoft.apb.project.client.scala.model.{ ProjectDescriptor => InternalProjectDescriptor }

import scala.scalajs.js.annotation.JSExportAll
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

@JSExportAll
case class ProjectDescriptor private[apb] (private[apb] val _internal: InternalProjectDescriptor) {
  val main: String                                = _internal.main
  val name: String                                = _internal.name
  val gav: Gav                                    = _internal.gav
  val classifier: ClientOption[String]            = _internal.classifier.asClient
  val tags: ClientList[String]                    = _internal.tags.asClient
  val dependencies: ClientList[ProjectDependency] = _internal.dependencies.asClient
}
