package org.mulesoft.apb.project.client.scala.model

import scala.scalajs.js.annotation.{JSExport, JSExportAll, JSExportTopLevel}

case class ProjectDescriptor(main: String,
                             name: String,
                             descriptorVersion: String,
                             gav: Gav,
                             classifier: Option[String],
                             tags: Seq[String],
                             dependencies: Seq[ProjectDependency]) {}
// TODO: documentation and tests?

@JSExportAll
case class Gav(groupId: String, assetId: String, version: String) {
  val path: String = s"$groupId/$assetId/$version/"
}

@JSExportAll
case class ProjectDependency(scope: DependencyScope, gav: Gav, hasExplicitScope: Boolean, shouldBeProvided: Boolean) {

  val absolutePath: String = "/exchange_modules/" + gav.path + "exchange.json"
}

@JSExportAll
sealed case class DependencyScope(scope: String)

@JSExportAll
@JSExportTopLevel("DependencyScope")
object DependencyScope {

  @JSExport("apply")
  def apply(scope: String): DependencyScope = scope match {
    case ValidationScope.scope => ValidationScope
    case ExtensionScope.scope  => ExtensionScope
    case _                     => DesignScope
  }

  val Design: DependencyScope     = DesignScope
  val Validation: DependencyScope = ValidationScope
  val Extension: DependencyScope  = ExtensionScope
}

@JSExportAll
@JSExportTopLevel("DesignScope")
object DesignScope extends DependencyScope("design")

@JSExportAll
@JSExportTopLevel("ValidationScope")
object ValidationScope extends DependencyScope("validation")

@JSExportAll
@JSExportTopLevel("ExtensionScope")
object ExtensionScope extends DependencyScope("design-extension")
