package org.mulesoft.apb.project.client.scala.model

import amf.core.internal.remote.Spec

import scala.scalajs.js.annotation.{JSExport, JSExportAll, JSExportTopLevel}

case class ProjectDescriptor(main: String,
                             name: String,
                             descriptorVersion: String,
                             gav: Gav,
                             classifier: Option[String],
                             tags: Seq[String],
                             apiVersion: Option[String],
                             organizationId: Option[String],
                             originalFormatVersion: Option[String],
                             metadata: Option[MetadataElement],
                             backwardsCompatible: Option[Boolean],
                             dependencies: Seq[ProjectDependency])
    extends GavAware {

  def classifierSpec: Option[Spec] = {
    classifier match {
      case Some(v) if v.contains("raml")                         => Some(Spec.RAML10)
      case Some(v) if v.contains("oas") || v.contains("swagger") => Some(Spec.OAS20)
      case Some(v) if v.contains("openapi")                      => Some(Spec.OAS30)
      case Some(v) if v.contains("graphql")                      => Some(Spec.GRAPHQL)
      case Some(v) if v.contains("grpc")                         => Some(Spec.GRPC)
      case Some(v) if v.contains("asyncapi")                     => Some(Spec.ASYNC20)
      case _                                                     => None
    }
  }
}
// TODO: documentation and tests?

object Gav {
  def unapply(gav: String): Option[Gav] = gav.split("/") match {
    case Array(group, asset, version) => Some(Gav(group, asset, version))
    case _                            => None
  }
}

@JSExportAll
case class Gav(groupId: String, assetId: String, version: String) {
  val path: String = s"$groupId/$assetId/$version/"
}

@JSExportAll
case class ProjectDependency(scope: DependencyScope,
                             gav: Gav,
                             hasExplicitScope: Boolean,
                             shouldBeProvided: Boolean,
                             parentClassifier: Option[String])
    extends GavAware {

  val absolutePath: String = "/exchange_modules/" + gav.path + "exchange.json"
}

trait GavAware {
  def gav: Gav
}

@JSExportAll
sealed case class DependencyScope(scope: String)

@JSExportAll
@JSExportTopLevel("DependencyScope")
object DependencyScope {

  @JSExport("apply")
  def apply(scope: String): DependencyScope = scope match {
    case ValidationScope.scope => ValidationScope
    case ExtensionScope.scope  => ExtensionScope
    case _                     => DesignScope
  }

  val Design: DependencyScope     = DesignScope
  val Validation: DependencyScope = ValidationScope
  val Extension: DependencyScope  = ExtensionScope
}

@JSExportAll
@JSExportTopLevel("DesignScope")
object DesignScope extends DependencyScope("design")

@JSExportAll
@JSExportTopLevel("ValidationScope")
object ValidationScope extends DependencyScope("validation")

@JSExportAll
@JSExportTopLevel("ExtensionScope")
object ExtensionScope extends DependencyScope("design-extension")

case class MetadataElement(branchId: Option[String], commitId: Option[String], projectId: Option[String])
