package org.mulesoft.apb.project.internal.engine

import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, ParsedDependency}
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor
import org.mulesoft.apb.project.internal.listener.RawReferenceListener

import scala.concurrent.Future
import scala.concurrent.ExecutionContext.Implicits.global

trait CollisionComputationHelper {

  protected def lookupRisksForRoot(config: ProjectConfiguration): Future[ProjectConfiguration] = {
    config.dependenciesLoaders.get(config.descriptor.gav.path) match {
      case None => Future.successful(config)
      case Some(loader) =>
        for {
          detectedFileCollisions <- MigrationRisk.lookup(loader, config.migrationRisks)
        } yield {
          val nextRisk = computeNextRisks(config.descriptor, Set.empty, config.migrationRisks, detectedFileCollisions)
          config.copy(migrationRisks = nextRisk)
        }
    }
  }

  protected def computeNextRisks(descriptor: ProjectDescriptor,
                                 pathsToCheck: Set[String],
                                 risks: MigrationRisks,
                                 foundFileCollisions: Set[String]): MigrationRisks = {
    val nextRisks = if (pathsToCheck.isEmpty) risks else risks.addPathsToCheck(pathsToCheck, descriptor.gav)
    nextRisks
      .addGavForPaths(foundFileCollisions, descriptor.gav)
  }

  protected def assignMigrationRisks(config: ProjectConfiguration): ProjectConfiguration = {
    val results = MigrationRiskValidations.create(config.migrationRisks, Some(config.descriptor.gav))
    config.copy(errors = config.errors.addProjectErrors(results))
  }
}
