package org.mulesoft.apb.project.internal.engine

import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, ParsedDependency}
import org.mulesoft.apb.project.internal.ops.FutureOps.filterSuccess

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object MigrationRisk extends CollisionComputationHelper {

  def compute(dependency: ParsedDependency, loader: ResourceLoader): Future[ParsedDependency] = {
    dependency match {
      case d: DesignDependency => lookup(loader, d.risks).map(detectAndComputeRisks(d, _))
      case _                   => Future.successful(dependency)
    }
  }

  def lookup(loader: ResourceLoader, risks: MigrationRisks): Future[Set[String]] = {
    val fetches = risks.pathsToCheck.map(x => loader.fetch(x).map(_.copy(url = x)))

    filterSuccess(fetches).map(_.map(_.url)).map(_.toSet)
  }

  protected def detectAndComputeRisks(designDependency: DesignDependency, collisions: Set[String]): DesignDependency = {

    val detectedAbsoluteRefs: Set[String] =
      designDependency.listener.map(_.getDetectedAbsoluteRefUri).getOrElse(Set.empty)
    val nextRisk =
      computeNextRisks(designDependency.descriptor, detectedAbsoluteRefs, designDependency.risks, collisions)
    designDependency.update(nextRisk)
  }
}
