package org.mulesoft.apb.project.internal.engine

import amf.core.client.common.remote.Content
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, ParsedDependency}
import org.mulesoft.apb.project.internal.ops.FutureOps.filterSuccess
import amf.core.internal.remote.{Context, File}

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object MigrationRisk extends CollisionComputationHelper {

  def compute(dependency: ParsedDependency, loader: ResourceLoader): Future[ParsedDependency] = {
    dependency match {
      case d: DesignDependency => lookup(loader, d.risks).map(detectAndComputeRisks(d, _))
      case _                   => Future.successful(dependency)
    }
  }

  def lookup(loader: ResourceLoader, risks: MigrationRisks): Future[Set[String]] = {
    processFetchers(risks.pathsToCheck.map(x => loader.fetch(x).map(_.copy(url = x))))
  }

  def processFetchers(fetches: Set[Future[Content]]): Future[Set[String]] =
    filterSuccess(fetches).map(_.map(_.url)).map(_.toSet)

  def processPath(path: String, root: String): String = {
    Context(platform, root).resolve(path)
  }
  def lookFromRoot(rls: List[ResourceLoader], configuration: ProjectConfiguration): Future[Set[String]] = {
    val config = AMFGraphConfiguration.empty().withResourceLoaders(rls)
    val fetches: Set[Future[Content]] = configuration.migrationRisks.pathsToCheck.map { path =>
      platform.fetchContent(processPath(path, configuration.mainFile), config).map { c =>
        c.copy(url = path)
      }
    }
    processFetchers(fetches)
  }

  protected def detectAndComputeRisks(designDependency: DesignDependency, collisions: Set[String]): DesignDependency = {

    val detectedAbsoluteRefs: Set[String] =
      designDependency.listener.map(_.getDetectedAbsoluteRefUri).getOrElse(Set.empty)
    val nextRisk =
      computeNextRisks(designDependency.descriptor, detectedAbsoluteRefs, designDependency.risks, collisions)
    designDependency.update(nextRisk)
  }
}
