package org.mulesoft.apb.project.internal.engine

import amf.core.client.common.validation.SeverityLevels
import amf.core.client.scala.validation.AMFValidationResult
import org.mulesoft.apb.project.client.scala.model.Gav
import org.mulesoft.apb.project.internal.validations.ProjectValidations.ProjectMigrationRedundancyRisk

object MigrationRiskValidations {

  def create(risks: MigrationRisks, root: Option[Gav] = None): List[AMFValidationResult] = {
    risks.allMigrationRiskDetections.map {
      case (path, gavList) =>
        val firstDetectedGav = risks.firstMigrationRiskDetection(path).path
        val detectedForRoot  = root.exists(gav => gavList.contains(gav))
        val gavsToReport     = root.map(gav => gavList.filter(x => x != gav)).getOrElse(gavList)
        AMFValidationResult(
          message(path, gavsToReport, detectedForRoot),
          SeverityLevels.VIOLATION,
          "",
          None,
          ProjectMigrationRedundancyRisk.id,
          None,
          Some(firstDetectedGav),
          Unit
        )
    }.toList
  }

  private def message(path: String, gavs: Set[Gav], detectedForRoot: Boolean): String = {
    val initialMessage =
      s"""Possible file collision for files in path $path
         |Please analyze the contents and leave the most updated content in the module from where it is referenced
         |Delete the files in the modules that don't reference that file.\n""".stripMargin
    val gavList         = gavs.map(x => s"- Project: ${x.path}").mkString("\n")
    val rootProjectItem = if (detectedForRoot) s"\n- Project: current" else ""
    initialMessage + gavList + rootProjectItem
  }
}
