package org.mulesoft.apb.project.internal.engine

import amf.aml.client.scala.model.document.{Dialect, DialectInstance}
import amf.apicontract.client.scala.{AMFLibraryResult, APIConfiguration}
import amf.apicontract.internal.spec.raml.RamlHeader.Raml10
import amf.core.client.scala.AMFParseResult
import amf.core.client.scala.config.AMFEventListener
import amf.core.client.scala.model.document.{BaseUnit, Module}
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.remote.Spec
import org.mulesoft.apb.project.client.scala.{ProjectConfiguration, ProjectErrors}
import org.mulesoft.apb.project.client.scala.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.scala.model.{
  DependencyScope,
  ExtensionScope,
  ProjectDescriptor,
  ValidationScope
}
import org.mulesoft.apb.project.internal.parser.APBEnv

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class MainFileInfo(loader: ResourceLoader,
                        descriptor: ProjectDescriptor,
                        config: ProjectConfiguration,
                        result: AMFParseResult,
                        parentClassifier: Option[String]) {
  val baseUnit: BaseUnit = result.baseUnit

  def parseCompanionLibrary: Future[Option[(String, Module)]] = {
    parentClassifier.flatMap {
      case v if v.contains("raml") => Some((Spec.RAML10, ".raml"))
//      case Spec.GRAPHQL => ".graphql"
//      case Spec.GRPC => ".proto3"
      case _ => Some((Spec.RAML10, ".raml")) // todo: current semex classifier is aml? need previous classifier?
    } map {
      case (spec, extension) =>
        val companionName = descriptor.main.substring(0, descriptor.main.lastIndexOf(".")) + extension
        parseCompanion(spec, companionName).recoverWith { case _: Throwable => Future.successful(None) }
    } getOrElse (Future.successful(None))
  }

  private def parseCompanion(spec: Spec, companionName: String) = {
    APIConfiguration
      .fromSpec(spec) // todo: check for graphql and grpc later on
      .withResourceLoader(loader)
      .baseUnitClient()
      .parseLibrary(companionName)
      .map(l => Some((companionName, l.library)))
  }

}

object MainFileInfoBuilder {
  def build(loader: ResourceLoader,
            descriptor: ProjectDescriptor,
            config: ProjectConfiguration,
            parentClassifier: Option[String]): Future[MainFileInfo] = {
    config.webApiParseConfig
      .withResourceLoader(loader)
      .baseUnitClient()
      .parse(APBEnv.projectProtocol + descriptor.main)
      .map(MainFileInfo(loader, descriptor, config, _, parentClassifier))
  }

}
