package org.mulesoft.apb.project.client.scala.descriptor

import amf.aml.client.scala.AMLConfiguration
import amf.aml.client.scala.model.document.DialectInstance
import amf.core.client.scala.errorhandling.IgnoringErrorHandler
import amf.core.internal.errorhandling.SYAMLJsonErrorHandler
import amf.core.internal.parser.YMapOps
import amf.core.internal.remote.Mimes
import org.mulesoft.apb.project.internal.generated.AnypointDescriptorDialectLoader
import org.mulesoft.apb.project.internal.parser.{
  AMLDescriptorPlugin,
  AMLExchangeDescriptorAdapter,
  ParserProviderCompanion,
  YMapLocalOps
}
import org.yaml.model.YMap
import org.yaml.parser.JsonParser

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object ExchangeDescriptorParser extends ParserProviderCompanion {
  def apply()                     = new ExchangeDescriptorParser("")
  def apply(base: Option[String]) = new ExchangeDescriptorParser(base.getOrElse(""))

  override def getProvider: Option[String] => DescriptorParser = apply

  override val descriptorFileName: String = "exchange.json"
  override val projectProtocol: String    = "file:///"
}

case class ExchangeDescriptorParser private[apb] (base: String) extends DescriptorParser {

  def parse(content: String): Future[DescriptorParseResult] = {
    for {
      version <- parseDescriptorVersion(content)
      dialect <- AnypointDescriptorDialectLoader.dialect(version)
      config <- Future.successful(
        AMLConfiguration.predefined().withDialect(dialect).withPlugin(AMLDescriptorPlugin(dialect)))
      parsed <- config.baseUnitClient().parseContent(content, Mimes.`application/json`)
      report <- config.baseUnitClient().validate(parsed.baseUnit.cloneUnit())
    } yield {
      val finalReport = report.copy(results = parsed.results ++ report.results)
      val descriptor  = AMLExchangeDescriptorAdapter.adapt(parsed.baseUnit.asInstanceOf[DialectInstance], base, version)
      DescriptorParseResult(descriptor, finalReport)
    }
  }

  private def parseDescriptorVersion(content: String) = {
    implicit val eh: SYAMLJsonErrorHandler = SYAMLJsonErrorHandler(IgnoringErrorHandler)
    val json                               = JsonParser(content)
    val rawValue                           = json.document().node.as[YMap].stringValueFor("descriptorVersion")
    val result = rawValue match {
      case Some("1.0.0") => "1.0.0"
      case Some("0.1.0") => "0.1.0"
      case Some(_)       => "1.0.0"
      case _             => "0.1.0"
    }
    Future.successful(result)
  }
}
