package org.mulesoft.apb.project.internal.validations

import amf.core.internal.validation.core.ValidationSpecification

object ProjectValidations {

  val UnreacheableAsset = ValidationSpecification("unreachable-asset", s"Unreachable asset")
  val ScopePresentInLegacyProject =
    ValidationSpecification("scope-present-in-legacy-project", s"Scope present in legacy project")
  val SuggestedExtensionDependency =
    ValidationSpecification("suggested-extension-dependency", s"Suggested extension dependency")
  val ProjectMigrationRedundancyRisk =
    ValidationSpecification("project-migration-redundancy-risk", "Project migration redundancy risk")

  val AbsolutePathUsage: ValidationSpecification = ValidationSpecification(
    "absolute-path",
    "Absolute references starting with '/' are not more allowed"
  )

  val MissingCompanionLibUses: ValidationSpecification = ValidationSpecification(
    "missing-companion-lib-uses",
    "Inclusion over Library API Fragment is mandatory for api-extensions dependencies."
  )
}
