package org.mulesoft.apb.project.internal.engine

import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

trait CollisionComputationHelper extends PlatformSecrets {

  protected def lookupRisksForRoot(config: ProjectConfiguration,
                                   rls: List[ResourceLoader]): Future[ProjectConfiguration] = {
    for {
      detectedFileCollisions <- MigrationRisk.lookFromRoot(rls, config)
    } yield {
      val nextRisk = computeNextRisks(config.descriptor, Set.empty, config.migrationRisks, detectedFileCollisions)
      config.copy(migrationRisks = nextRisk)
    }

  }

  protected def computeNextRisks(descriptor: ProjectDescriptor,
                                 pathsToCheck: Set[String],
                                 risks: MigrationRisks,
                                 foundFileCollisions: Set[String]): MigrationRisks = {
    val nextRisks = if (pathsToCheck.isEmpty) risks else risks.addPathsToCheck(pathsToCheck, descriptor.gav)
    nextRisks
      .addGavForPaths(foundFileCollisions, descriptor.gav)
  }

  protected def assignMigrationRisks(config: ProjectConfiguration): ProjectConfiguration = {
    val results = MigrationRiskValidations.create(config.migrationRisks, Some(config.descriptor.gav))
    config.copy(errors = config.errors.addProjectErrors(results))
  }
}
