package org.mulesoft.apb.project.internal.config

import amf.apicontract.client.scala._
import amf.graphql.client.scala.GraphQLConfiguration
import amf.grpc.client.scala.GRPCConfiguration
import amf.shapes.client.scala.config.JsonSchemaConfiguration

object ClassifierConfigProvider {

  def get(classifier: String): AMFConfiguration = classifier match {
    case "grpc"        => GRPCConfiguration.GRPC()
    case "graphql"     => GraphQLConfiguration.GraphQL()
    case "evented-api" => AsyncAPIConfiguration.Async20()
    case "raml"        => RAMLConfiguration.RAML()
    case "oas"         => OASConfiguration.OAS()
    case "json-schema" => ConfigurationAdapter.adapt(JsonSchemaConfiguration.JsonSchema())
    case _             => APIConfiguration.API()
  }
}
