package org.mulesoft.apb.project.internal.config

import amf.apicontract.client.scala._
import amf.core.internal.remote.Spec
import amf.graphql.client.scala.GraphQLConfiguration
import amf.graphqlfederation.client.scala.GraphQLFederationConfiguration
import amf.grpc.client.scala.GRPCConfiguration
import amf.shapes.client.scala.config.JsonSchemaConfiguration

object ConfigProvider {

  def fromClassifier(classifier: String): AMFConfiguration = classifier match {
    case raml if raml.contains("raml") => RAMLConfiguration.RAML()
    case oas if oas.contains("oas")    => OASConfiguration.OAS()
    case "evented-api"                 => AsyncAPIConfiguration.Async20()
    case "json-schema"                 => ConfigurationAdapter.adapt(JsonSchemaConfiguration.JsonSchema())
    case "graphql"                     => GraphQLConfiguration.GraphQL()
    case "graphql-federation"          => GraphQLFederationConfiguration.GraphQLFederation()
    case "grpc"                        => GRPCConfiguration.GRPC()
    case _                             => APIConfiguration.API()
  }

  def fromSpec(spec: Spec): AMFConfiguration = spec match {
    case Spec.RAML08             => RAMLConfiguration.RAML08()
    case Spec.RAML10             => RAMLConfiguration.RAML10()
    case Spec.OAS20              => OASConfiguration.OAS20()
    case Spec.OAS30              => OASConfiguration.OAS30()
    case Spec.ASYNC20            => AsyncAPIConfiguration.Async20()
    case Spec.JSONSCHEMA         => ConfigurationAdapter.adapt(JsonSchemaConfiguration.JsonSchema())
    case Spec.GRAPHQL            => GraphQLConfiguration.GraphQL()
    case Spec.GRAPHQL_FEDERATION => GraphQLFederationConfiguration.GraphQLFederation()
    case Spec.GRPC               => GRPCConfiguration.GRPC()
    case _ =>
      throw UnrecognizedSpecException(
          s"Spec ${spec.id} not supported. Supported specs are ${Spec.RAML08.id}, ${Spec.RAML10.id}, ${Spec.OAS20.id}, ${Spec.OAS30.id}, ${Spec.ASYNC20.id}, ${Spec.JSONSCHEMA.id}, ${Spec.GRAPHQL.id}, ${Spec.GRAPHQL_FEDERATION.id}, ${Spec.GRPC.id}"
      )
  }
}
