package org.mulesoft.apb.project.client.platform.descriptor

import amf.apicontract.internal.convert.ApiClientConverters.{ClientList, ClientOption}
import org.mulesoft.apb.project.client.platform.model.{Gav, MetadataElement, ProjectDependency, ProjectDescriptor}
import org.mulesoft.apb.project.client.scala.descriptor.{ExchangeDescriptorBuilder => InternalExchangeDescriptorBuilder}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class ExchangeDescriptorBuilder private[apb] (private[apb] val _internal: InternalExchangeDescriptorBuilder) {

  @JSExportTopLevel("ExchangeDescriptorBuilder")
  def this(main: String) = this(InternalExchangeDescriptorBuilder(main))

  @JSExportTopLevel("ExchangeDescriptorBuilder")
  def this(baseDescriptor: ProjectDescriptor) = this(InternalExchangeDescriptorBuilder(baseDescriptor._internal))

  def withDescriptorVersion(descriptorVersion: String): ExchangeDescriptorBuilder =
    _internal.withDescriptorVersion(descriptorVersion)
  def withName(name: String): ExchangeDescriptorBuilder = _internal.withName(name)
  def withGav(gav: Gav): ExchangeDescriptorBuilder      = _internal.withGav(gav._internal)
  def withGav(groupId: String, assetId: String, version: String): ExchangeDescriptorBuilder =
    _internal.withGav(new Gav(groupId, assetId, version)._internal)
  def withClassifier(classifier: String): ExchangeDescriptorBuilder = _internal.withClassifier(classifier)
  def withTags(tags: ClientList[String]): ExchangeDescriptorBuilder = _internal.withTags(tags.asInternal)
  def withTag(tag: String): ExchangeDescriptorBuilder               = _internal.withTag(tag)
  def withApiVersion(apiVersion: String): ExchangeDescriptorBuilder = _internal.withApiVersion(apiVersion)
  def withOrganizationId(organizationId: String): ExchangeDescriptorBuilder =
    _internal.withOrganizationId(organizationId)
  def withOriginalFormatVersion(originalFormatVersion: String): ExchangeDescriptorBuilder =
    _internal.withOriginalFormatVersion(originalFormatVersion)
  def withMetadata(metadata: MetadataElement): ExchangeDescriptorBuilder = _internal.withMetadata(metadata._internal)
  def withMetadata(
      branchId: ClientOption[String],
      commitId: ClientOption[String],
      projectId: ClientOption[String]
  ): ExchangeDescriptorBuilder = _internal.withMetadata(new MetadataElement(branchId, commitId, projectId)._internal)
  def withBackwardsCompatible(backwardsCompatible: Boolean): ExchangeDescriptorBuilder =
    _internal.withBackwardsCompatible(backwardsCompatible)
  def withPublishWithRefFiles(publishWithRefFiles: Boolean): ExchangeDescriptorBuilder =
    _internal.withPublishWithRefFiles(publishWithRefFiles)
  def withDescription(description: String): ExchangeDescriptorBuilder = _internal.withDescription(description)
  def withProjectId(projectId: String): ExchangeDescriptorBuilder     = _internal.withProjectId(projectId)
  def withDependencies(dependencies: ClientList[ProjectDependency]): ExchangeDescriptorBuilder =
    _internal.withDependencies(dependencies.asInternal)
  def withDependency(dependency: ProjectDependency): ExchangeDescriptorBuilder =
    _internal.withDependency(dependency._internal)

  def build(): ClientFuture[ProjectDescriptor] = _internal.build().asClient

}
