package org.mulesoft.apb.project.internal.dependency

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.dependency.ExchangeModulePathHandler

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

class APBResourceLoader private[apb] (private val loaders: Map[String, ResourceLoader]) extends ResourceLoader {

  override def fetch(resource: String): Future[Content] = {
    val dependencyContent = for {
      ph           <- ExchangeModulePathHandler(resource)
      gav          <- ph.gav
      loader       <- loaders.get(gav)
      relativePath <- ph.relativePath
    } yield {
      loader.fetch(relativePath).map(_.copy(url = ph.exchangePath))
    }
    dependencyContent.getOrElse(Future.failed(ModuleNotFoundException(resource)))
  }

  override def accepts(resource: String): Boolean = {
    ExchangeModulePathHandler(resource).flatMap(ph => ph.gav).exists(loaders.contains)
  }
}

case class ModuleNotFoundException(resource: String)
    extends Throwable(s"Module for resource: $resource not found among dependencies")
