package org.mulesoft.apb.project.client.platform.descriptor

import amf.core.client.platform.validation.AMFValidationReport
import org.mulesoft.apb.project.client.platform.model.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.descriptor.{
  DescriptorParseResult => InternalDescriptorParseResult,
  ExchangeDescriptorHandler => InternalExchangeDescriptorHandler
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class DescriptorParseResult private[apb] (private[apb] val _internal: InternalDescriptorParseResult) {
  def descriptor: ProjectDescriptor = _internal.descriptor
  def report: AMFValidationReport   = _internal.report
}

@JSExportAll
@JSExportTopLevel("ExchangeDescriptorHandler")
object ExchangeDescriptorHandler {

  def parse(content: String): ClientFuture[DescriptorParseResult] =
    InternalExchangeDescriptorHandler().parse(content).asClient

  def parse(content: String, base: String): ClientFuture[DescriptorParseResult] =
    InternalExchangeDescriptorHandler(base).parse(content).asClient

  def render(descriptor: ProjectDescriptor): ClientFuture[String] =
    InternalExchangeDescriptorHandler().render(descriptor._internal).asClient

}
