package org.mulesoft.apb.project.client.scala.dependency

import org.mulesoft.apb.project.client.scala.dependency.ExchangeModulePathHandler.EXCHANGE_MODULES
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor

class ExchangeModulePathHandler private (resource: String) {

  private lazy val gavPath: String = resource.split(EXCHANGE_MODULES + "/").last
  lazy val gav: Option[String] = {
    val strings: Array[String] = gavPath.split('/')
    if (strings.length > 3)
      Some(strings(0) + "/" + strings(1) + "/" + strings(2) + "/")
    else None
  }

  lazy val relativePath: Option[String] = gav.map("file://" + gavPath.stripPrefix(_))
  lazy val exchangePath: String         = s"file://$EXCHANGE_MODULES/$gavPath"

}

object ExchangeModulePathHandler {
  val EXCHANGE_MODULES = "exchange_modules"

  def apply(resource: String): Option[ExchangeModulePathHandler] =
    if (resource.contains(EXCHANGE_MODULES)) Some(new ExchangeModulePathHandler(resource)) else None

  def buildPath(projectDescriptor: ProjectDescriptor) =
    s"file://$EXCHANGE_MODULES/${projectDescriptor.gav.path}${projectDescriptor.main}"

  def buildPath(groupId: String, assetId: String, version: String, resource: String, protocol: String): String = {
    protocol + EXCHANGE_MODULES + "/" + groupId + "/" + assetId + "/" + version + "/" + resource.stripPrefix(protocol)
  }

}
