package org.mulesoft.apb.project.client.scala.transformation

import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.errorhandling.AMFErrorHandler
import amf.core.client.scala.model.document.BaseUnit
import amf.core.client.scala.transform.TransformationStep
import amf.shapes.client.scala.model.document.JsonSchemaDocument

class JSONDocumentRefCleaningTransformationStage() extends TransformationStep() {

  override def transform(
      model: BaseUnit,
      errorHandler: AMFErrorHandler,
      configuration: AMFGraphConfiguration
  ): BaseUnit = {
    val filteredReferences = model.references.filterNot(_.isInstanceOf[JsonSchemaDocument])
    model.withReferences(filteredReferences)
    model
  }

}
