package org.mulesoft.apb.project.internal.engine

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.remote.{Context, UnsupportedUrlScheme}
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, ParsedDependency}
import org.mulesoft.apb.project.internal.ops.FutureOps.filterSuccess

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object MigrationRisk extends CollisionComputationHelper {

  def compute(dependency: ParsedDependency, loader: ResourceLoader): Future[ParsedDependency] = {
    dependency match {
      case d: DesignDependency => lookup(loader, d.risks).map(detectAndComputeRisks(d, _))
      case _                   => Future.successful(dependency)
    }
  }

  def lookup(loader: ResourceLoader, risks: MigrationRisks): Future[Set[String]] = {
    processFetchers(risks.pathsToCheck.map(x => loader.fetch(x).map(_.copy(url = x))))
  }

  def processFetchers(fetches: Set[Future[Content]]): Future[Set[String]] =
    filterSuccess(fetches).map(_.map(_.url)).map(_.toSet)

  def processPath(path: String, root: String): String = {
    val resolvedPath = Context(platform, root).resolve(path)
    if (resolvedPath.startsWith("file:/")) resolvedPath else "file://" + resolvedPath
  }

  // TODO: remove after HF
  private def loaderConcat(url: String, loaders: Seq[ResourceLoader]): Future[Content] = loaders.toList match {
    case Nil         => Future.failed(new UnsupportedUrlScheme(url))
    case head :: Nil => head.fetch(url)
    case head :: tail =>
      head.fetch(url).recoverWith { case _ =>
        loaderConcat(url, tail)
      }
  }

  def fetchContent(url: String, rls: List[ResourceLoader]): Future[Content] =
    loaderConcat(url, rls.filter(_.accepts(url)))

  def lookFromRoot(rls: List[ResourceLoader], configuration: ProjectConfiguration): Future[Set[String]] = {
    val fetches: Set[Future[Content]] = configuration.migrationRisks.pathsToCheck.map { path =>
      fetchContent(processPath(path, configuration.mainFile), rls).map { c =>
        c.copy(url = path)
      }
    }
    processFetchers(fetches)
  }

  protected def detectAndComputeRisks(designDependency: DesignDependency, collisions: Set[String]): DesignDependency = {

    val detectedAbsoluteRefs: Set[String] =
      designDependency.listener.map(_.getDetectedAbsoluteRefUri).getOrElse(Set.empty)
    val nextRisk =
      computeNextRisks(designDependency.descriptor, detectedAbsoluteRefs, designDependency.risks, collisions)
    designDependency.update(nextRisk)
  }
}
